<?php

namespace App\Http\Controllers\Api;

use App\Models\Place;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Services\SearchPlaceService;

class AirportsController extends Controller
{
    /**
     * @param SearchPlaceService $service
     *
     * @return JsonResponse
     */
    public function getAvailablePlaces(SearchPlaceService $service): JsonResponse
    {
        $data = $service->findAvailablePlaces(request()->query('qry'));
        
        return response()->json($data);
    }
    
    public function getAvailableDestinations(SearchPlaceService $service): JsonResponse
    {
        $fromName = request('placeFrom');
    
        $place = Place::where('PlaceNameSEO', $fromName)->first();
        
        if (!$place) {
            return response()->json([]);
        }
        
        $data = $service->findAvailableDestinations($place);
        
        return response()->json($data);
    }
    
    /**
     * @param SearchPlaceService $service
     *
     * @return JsonResponse
     */
    public function getPlacesGroupedByCountry(SearchPlaceService $service): JsonResponse
    {
        $data = $service->getPlacesGroupedByCountry();
        
        return response()->json($data);
    }
}
