<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Services\BookingDataService;

class BookingController extends Controller
{
    /**
     * @var BookingDataService
     */
    private $bookingDataService;
    
    /**
     * @param BookingDataService $bookingDataService
     */
    public function __construct(BookingDataService $bookingDataService)
    {
        $this->bookingDataService = $bookingDataService;
    }
    
    /**
     * @return JsonResponse
     */
    public function save(): JsonResponse
    {
        return response()->json($this->bookingDataService->save(request()->all()));
    }
}
