<?php

namespace App\Http\Controllers\Api;

use App\Models\Extra;
use App\Models\ExtraMaster;
use App\Models\OrderExtrasTemp;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\DriverExtrasResource;

class DriverExtrasController extends Controller
{
    /**
     * @param $driverId
     *
     * @return JsonResponse
     */
    public function index($driverId): JsonResponse
    {
        $extras = Extra::where('OwnerID', $driverId)->get();
    
        $items = [];
    
        if ($extras->count() > 0) {
            foreach ($extras as $extra) {
                $items[] = array_merge(
                    $extra->toArray(),
                    ['order' => ExtraMaster::where('ID', $extra->ServiceID)->first()->DisplayOrder]
                );
            }
        
            usort($items, function ($first, $second) {
                return $first['order'] > $second['order'];
            });
        }
        
        return response()->json([
            'extras' => collect($items)->map(function ($item) {
                return new DriverExtrasResource($item);
            })
        ]);
    }
    
    /**
     *
     * @return JsonResponse
     */
    public function store(): JsonResponse
    {
        // Delete all previously entered extras as a precaution
        OrderExtrasTemp::where('OrderDetailsID', request()->DetailsID_1)
                       ->orWhere('OrderDetailsID', request()->DetailsID_2)
                       ->delete();
        
        // Add latest version of extras
        $this->createExtras();
        
        return response()->json([], 201);
    }
    
    /**
     * Persist to database.
     */
    private function createExtras()
    {
        foreach (json_decode(request()->extras, true) as $key => $val) {
            [$way, $serviceId] = explode('_', $key);
            
            [$sum, $Qty] = explode('_', $val);
            
            $extra = Extra::find($serviceId);
            
            OrderExtrasTemp::create([
                'OrderDetailsID' => $way == 1 ? request()->DetailsID_1 : request()->DetailsID_2,
                'ServiceName'    => $extra->ServiceEN,
                'ServiceID'      => $serviceId,
                'Price'          => $extra->Price,
                'DriverPrice'    => $extra->DriverPrice,
                'Qty'            => $Qty,
                'Sum'            => $sum,
            ]);
        }
    }
}
