<?php

namespace App\Http\Controllers\Api;

use App\Models\Article;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller;

class HelpCenterController extends Controller
{
    public function getCategories()
    {
        $title = '';
        
        if (request()->exists('category')) {
            $slug = request()->query('category');
            
            // We are fetching one category, but in all languages, that's why it is a collection.
            $category = Article::where('Slug', $slug)->get();
            
            if ($category->isEmpty()) {
                return response()->json([], 404);
            }
            
            $items = Article::select('Title', 'Article', 'Language')
                            ->where('Published', 1)
                            ->orderBy('Position')
                            ->where('Page', $category->firstWhere('Language', 'en')->Title)
                            ->where('Language', request()->header('Accept-Language'))
                            ->get()
                            ->map(function ($article) {
                                return [
                                    'title' => trim($article->Title),
                                    'text'  => $article->Article,
                                ];
                            });
            
            $title = $category->firstWhere('Language', request()->header('Accept-Language'))->Title;
        } else {
            $items = Article::select('Title', 'Slug', 'Language', 'HTMLBefore')
                            ->where('Page', 'faq-block')
                            ->where('Published', 1)
                            ->where('Language', request()->header('Accept-Language'))
                            ->orderBy('Position')
                            ->get()
                            ->map(function ($article) {
                                return [
                                    'title' => trim($article->Title),
                                    'img'   => $article->HTMLBefore,
                                    'slug' => $article->Slug
                                ];
                            });
        }
        
        return response()->json([
            'items' => $items,
            'title' => $title
        ]);
    }
}
