<?php

namespace App\Http\Controllers\Api;

use App\Models\Page;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function get(Request $request)
    {
        $page = $this->getPageFor($request->page);
        
        if (!$page) {
            return response()->json([
                'error' => 'Wrong page'
            ], 422);
        }
        
        return response()->json(compact('page'));
    }
    
    /*
     * Helper method for retrieving page.
     */
    private function getPageFor($param)
    {
        $lang = Str::upper(app()->getLocale());
        
        return Page::where('MenuTitle', $param)
                   ->select("Content{$lang} as text", "Title{$lang} as title")
                   ->first();
    }
}
