<?php

namespace App\Http\Controllers\Api;

use App\Models\Terminal;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;

class TerminalsController extends Controller
{
    /**
     * @return JsonResponse
     */
    public function getTop(): JsonResponse
    {
        $items = Cache::rememberForever('top.terminals.' . Lang(), function () {
            return DB::table('v4_Terminals as t')
                     ->select('t.TerminalID', 't.MPOrder', 't.ImageMP', 'p.PlaceName'.Lang(), 'p.PlaceNameSEO')
                     ->join('v4_Places as p', 't.TerminalID', 'p.PlaceID')
                     ->where('t.MP', 1)
                     ->orderBy('t.MPOrder')
                     ->get()
                     ->map(function ($item) {
                         return [
                             'title' => $item->{'PlaceName' . Lang()},
                             'img'   => 'https://transfersplitairport.com' . $item->ImageMP,
                             'url'   => 'taxi-transfers-from-' . $item->PlaceNameSEO,
                         ];
                     });
        });
        
        return response()->json([
            'items' => $items,
        ]);
    }
    
    /**
     * @return JsonResponse
     */
    public function getDescription(): JsonResponse
    {
        if (! request()->id) {
            return response()->json([], 422);
        }
        
        $data = Terminal::where('TerminalID', request()->id)
                        ->select('TerminalID', 'Description')
                        ->first();
    
        return response()->json([
            'description' => optional($data)->Description[strtolower(Lang())]
        ]);
    }
    
    /**
     * @return JsonResponse
     */
    public function bustCache(): JsonResponse
    {
       /* if (request()->query('hash') !== config('app.translation-cache-buster')) {
            return response()->json([
                'message' => 'Hash is not valid.'
            ], 422);
        }
        */
        Cache::forget('top.terminals.EN');
        Cache::forget('top.terminals.DE');
        Cache::forget('top.terminals.FR');
        Cache::forget('top.terminals.RU');
        
        return response()->json([
            'message' => 'Top terminals busted successfully.'
        ]);
    }
}
