<?php

namespace App\Http\Controllers\Api;

use App\Models\LanguageLine;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TranslationsController extends Controller
{
    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function get(Request $request): JsonResponse
    {
        return response()->json([
            'translations' => [
                'labels' => LanguageLine::getTranslationsForGroup($request->query('locale'), 'api'),
                'validations' => LanguageLine::getTranslationsForGroup($request->query('locale'), 'api/validations'),
            ]
        ]);
    }
    
    /**
     * @return JsonResponse
     */
    public function bustCache(): JsonResponse
    {
        /*if (request()->query('hash') !== config('app.translation-cache-buster')) {
            return response()->json([
                'message' => 'Hash is not valid.'
            ], 422);
        }*/
        
        $translation = new LanguageLine();
    
        $translation->text = ['en' => null, 'de' => null, 'fr' => null, 'ru' => null];
        $translation->group = 'api';
    
        $translation->flushGroupCache();
    
        $translation->group = 'api/validations';
    
        $translation->flushGroupCache();
        
        return response()->json([
            'message' => 'Translations busted successfully.'
        ]);
    }
}
