<?php

namespace App\Http\Controllers\Api;

use App\Mail\TravelAgencyMail;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;

class TravelAgenciesPartnershipProposalController extends Controller
{
    public function index()
    {
        $navigation = [
            'title' => 'for travel agencies'
        ];
        
        $header = [
            'title'    => 'Partnership proposal for travel agencies',
            'subtitle' => 'Sell transfers and get Your commission in advance.',
            'btnText'  => 'START EARNING TODAY',
        ];
        
        $features = [
            [
                'title'    => 'Join us',
                'subtitle' => 'In a few easy steps become our partner, log in to your account and start booking.',
                'img'      => 'icon1.png',
            ],
            [
                'title'    => 'Sell',
                'subtitle' => 'We will organize the transfer, customers will enjoy the service and you will get a reward.',
                'img'      => 'icon2.png',
            ],
            [
                'title'    => 'Get Your money',
                'subtitle' => 'Boost your income by getting your commission in advance.',
                'img'      => 'icon3.png',
            ],
        ];
        
        $hero = [
            [
                'title'    => 'INCREASE YOUR PROFIT WITH JAMTRANSFER',
                'subtitle' => 'The more you book, more commission you will receive. <br> We can help you earn more money.',
                'btnText'  => 'REQUEST YOUR FREE ACCOUNT',
                'helpText' => 'If you have any questions before filing registration form, please
                               <a href="mailto:booking@jamtransfer.com?subject=Travel Agencies Request">contact us here</a>',
            ],
            [
                'title'    => 'START EARNING MORE MONEY',
                'subtitle' => 'We will always try to meet all your requests and offer you the best possible prices.',
                'btnText'  => 'START EARNING TODAY',
                'helpText' => 'If you have any questions before filing registration form, please
                               <a href="mailto:booking@jamtransfer.com?subject=Travel Agencies Request">contact us here</a>',
            ],
            [
                'title'    => 'REGISTER WITHOUT OBLIGATION',
                'subtitle' => 'We can help you improve your sale, help your clients, and start earning extra income.',
                'btnText'  => 'REQUEST YOUR FREE ACCOUNT',
                'helpText' => 'If you have any questions before filing registration form, please
                               <a href="mailto:booking@jamtransfer.com?subject=Travel Agencies Request">contact us here</a>',
            ],
        ];
        
        $showcase = [
            'title'    => 'Various types of transfers for any request',
            'subtitle' => 'Each transfer includes meet and greet service and luggage assistance.',
            'items'    => [
                [
                    'title'   => 'Standard',
                    'details' => 'Comfortable and affordable transfer for any client.',
                    'img'     => 'car-standard.png',
                ],
                [
                    'title'   => 'Premium and first class',
                    'details' => 'High class vehicles for special requests.',
                    'img'     => 'car-premium.png',
                ],
                [
                    'title'   => 'Minivan',
                    'details' => 'Perfect vehicle type for families with children.',
                    'img'     => 'car-minivan.png',
                ],
                [
                    'title'   => 'Minibus and Bus',
                    'details' => 'Best option for large groups.',
                    'img'     => 'car-bus.png',
                ],
            ],
        ];
        
        $easyToUse = [
            'title' => 'Easy to use',
            'list'  => [
                [
                    'title'   => 'Simple registration',
                    'details' => 'Quick registration without any fees and obligation.',
                ],
                [
                    'title'   => 'Agent Interface',
                    'details' => 'The user interface is made according to the needs of existing agents in order to benefit them.',
                ],
                [
                    'title'   => '24/7 customer service',
                    'details' => 'We approach every agency individually. Our customer service representative is always available to help (24/7).',
                ],
                [
                    'title'   => 'Worldwide coverage',
                    'details' => 'We provide transfer services all over the world, to more than 10 000 destinations.',
                ],
            ],
            'icons' => [
                [
                    'img'  => 'gift.png',
                    'text' => 'No cancellation fee',
                ],
                [
                    'img'  => 'smiley.png',
                    'text' => 'Meet and greet service',
                ],
                [
                    'img'  => 'user.png',
                    'text' => '15 years of experience',
                ],
                [
                    'img'  => 'airplane.png',
                    'text' => 'Flight monitoring',
                ],
                [
                    'img'  => 'clock.png',
                    'text' => '60 minutes waiting time included',
                ],
                [
                    'img'  => 'heart.png',
                    'text' => 'All inclusive service',
                ],
            ],
        ];
        
        $customers = [
            'title'    => 'Our customers',
            'subtitle' => 'Click above to see what our customers say about us',
            'items'    => [
                [
                    'img'    => 'customer1.png',
                    'name'   => 'Natalia G.',
                    'text'   => 'Very good service. Everything was on time. Very friendly, helpful and professional driver! Highly recommend!',
                    'source' => 'trip_advisor.png',
                    'link'   => 'https://www.tripadvisor.com/ShowUserReviews-g187265-d10955395-r465556375-Jam_Transfer-Lyon_Rhone_Auvergne_Rhone_Alpes.html#REVIEWS',
                ],
                [
                    'img'    => 'customer2.png',
                    'name'   => 'Tom R.',
                    'text'   => 'This is the second time we have used Jam transfer, They never let you down -drivers are always very friendly and helpful - happy to go the extra mile.',
                    'source' => 'trip_advisor.png',
                    'link'   => 'https://www.feefo.com/en-US/reviews/j-a-m-transfer?displayFeedbackType=SERVICE&timeFrame=YEAR',
                ],
                [
                    'img'    => 'customer3.png',
                    'name'   => 'Russel L.',
                    'text'   => 'From logging on to arrival at our destination everything worked perfectly. Taxi driver very friendly and helpful.',
                    'source' => 'trip_advisor.png',
                    'link'   => 'https://www.tripadvisor.com/ShowUserReviews-g187265-d10955395-r465556375-Jam_Transfer-Lyon_Rhone_Auvergne_Rhone_Alpes.html#REVIEWS',
                ],
                [
                    'img'    => 'customer4.png',
                    'name'   => 'Vlad D.',
                    'text'   => 'We had a transfer from the airport in Geneva to Val d Iser, it was a pleasure riding with, will book with them for other transfers definitely.',
                    'source' => 'trip_advisor.png',
                    'link'   => 'https://www.feefo.com/en-US/reviews/j-a-m-transfer?displayFeedbackType=SERVICE&timeFrame=YEAR',
                ],
            ],
        ];
        
        $partners = [
            'title' => 'Respected partners',
            'items' => [
                'partner1.png',
                'partner2.png',
                'partner3.png',
                'partner4.png',
                'partner5.png',
            ]
        ];
        
        $modalForm = [
            'title' => 'Partnership proposal for travel agencies',
            'subtitle' => 'Please fill out all of the necessary details',
            'btnText' => 'Complete my registration',
        ];
        
        return response()->json(compact('navigation', 'header', 'features', 'hero', 'showcase', 'easyToUse', 'customers', 'partners', 'modalForm'));
    }
    
    public function proposal()
    {
        request()->validate([
            'company'    => 'required',
            'address'    => 'required',
            'country'    => 'required',
            'email'      => 'required|email',
            'mobile'     => 'required',
            'tax_number' => 'required',
        ]);
        
        Mail::to([
            'agent@jamtransfer.com',
        ])->send(new TravelAgencyMail(request()->all()));
        
        return response()->json([
            'message' => 'Thank You. We will contact You shortly'
        ]);
    }
}
