<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DriverExtrasResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request): array
    {
        return [
            'id' => $this['ID'],
            'name' => $this->parseName($this['Service' . Lang()]),
            'icon' => $this->parseImage($this->parseName($this['ServiceEN'])),
            'description' => $this->parseDescription($this['Service' . Lang()]),
            'price' => $this['Price'],
            'driver_price' => $this['DriverPrice'],
            'driver_id' => $this['OwnerID'],
            'service_id' => $this['ServiceID'],
            'service' => $this['Service'],
            'provision' => $this['Provision'],
        ];
    }
    
    /**
     * @param string $data
     *
     * @return string
     */
    private function parseName(string $data): string
    {
        return trim(explode('(', $data)[0]);
    }
    
    /**
     * @param string $data
     *
     * @return string|null
     */
    private function parseDescription(string $data): string
    {
        if (strpos($data, "(")) {
            $str = substr($data, strpos($data, "("));

            return $str;
        }
        
        return '';
    }
    
    private function parseImage(string $data)
    {
        $images = [
            'Infant Seat' => 'infant_seat.png',
            'Child Seat' => 'child_seat.png',
            'Booster Seat' => 'booster_seat.png',
            'Baby Stroller' => 'baby_stroller.png',
            'Skis/Snowboard' => 'skis_snowboard.png',
            'Bicycle' => 'bicycle.png',
            'Golf Bag' => 'golf_bag.png',
            'Wheelchair' => 'wheelchair.png',
            'Extra luggage' => 'extra_luggage.png',
            'Extra stop in same town' => 'extra_stop.png',
            'Waiting time per 1 starting hour' => 'waiting_time.png',
        ];
        
        
        if (array_key_exists($data, $images)) {
            return $images[$data];
        }
        
        return null;
    }
}
