<?php

namespace App\Providers;

use App\Models\Place;
use App\Services\SearchPlaceService;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app->bind(SearchPlaceService::class, function ($app) {
            return new SearchPlaceService($app->make(Place::class));
        });
    }
}
