<?php

namespace App\Services;

use App\Models\AuthUser;
use App\Models\OrderDetailsTemp;
use App\Models\OrderMasterTemp;
use Illuminate\Support\Facades\Schema;

class BookingDataService
{
    /**
     * @var string
     */
    private $driverEmail;

    /**
     * @var string
     */
    private $driverTel;
    
    /**
     * @return array
     */
    public static function get(): array
    {
        error_reporting(0);

        $allRecords = [];
        
        if (!request()->header('tok')) {
            return [];
        }

        // IOS Fix
//        if (! session()->has('TOK') or empty(session()->get('TOK')) && (isset(request()->TOK) and ! empty(request()->TOK))) {
//            session()->put('TOK', request()->TOK);
//        }
        
        $orderMasterTemp = OrderMasterTemp::where('MOrderKey', request()->header('tok'))->first();

        if ($orderMasterTemp) {
            $allRecords['Master'] = $orderMasterTemp->toArray();

            $orderDetailsTemp = OrderDetailsTemp::where('OrderID', $orderMasterTemp->MOrderID)->get()->toArray();

            foreach ($orderDetailsTemp as $detail) {
                $allRecords[] = $detail;
            }
        }

        return $allRecords;
    }
    
    /**
     * Persist booking data to database.
     *
     * @param $data
     *
     * @return array
     */
    public function save($data): array
    {
        // todo: treba da se save-uje MPayNow i MPayLater u zavisnosti sta je izabrao kao metod placanja.
        // todo: mozda ovde ispitivati request, da li ima MPaymentMethod, pa u zavisnosti od toga save-ovati polja
        
        $request = $data;

        if (!$request['MOrderDate']) {
            $request['MOrderDate'] = date("Y-m-d");
        }
        
        if (!$request['MOrderTime']) {
            $request['MOrderTime'] = date("H:i:s");
        }
        
        if (!$request['OrderDate']) {
            $request['OrderDate'] = date("Y-m-d");
        }
        
        if (!$request['XOrderDate']) {
            $request['XOrderDate'] = date("Y-m-d");
        }
        
        // Driver data
        $this->driverEmail = '';
        $this->driverTel = '';

        $allRecords = [];

        $returnTransfer = $request['returnTransfer'];

        // cijene za returnTransfer su uduplane, treba ih prepolovit
        if ($returnTransfer && isset($request['DetailPrice']) && isset($request['DriversPrice'])) {
            $request['DetailPrice'] /= 2;
            $request['DriversPrice'] /= 2;
        }

        if (isset($request['DriverID']) and $request['DriverID'] != '') {
            static::getDriverDetails($request['DriverID']);
        }
        
        $orderMasterTempFields = static::getTableFields(OrderMasterTemp::class);
        $orderDetailsTempFields = static::getTableFields(OrderDetailsTemp::class);
        $request['MOrderKey'] = $request['MOrderKey'] ?? request()->header('tok');

        $orderMasterTemp = OrderMasterTemp::updateOrCreate(
            ['MOrderKey' => $request['MOrderKey']],
            collect($request)->intersectByKeys(array_flip($orderMasterTempFields))->toArray()
        );

        $allRecords['MOrderID'] = $orderMasterTemp->MOrderID;

        [$updateFirst, $updateReturn, $addFirst, $addReturn, $deleteReturn] = self::handle(count($orderMasterTemp->details), $returnTransfer);

        // UPDATE FIRST
        if ($updateFirst) {
            $firstOrderDetailsTemp = $orderMasterTemp->details->first();

            if ($firstOrderDetailsTemp->TNo == 1) {
                $data = collect($request)->intersectByKeys(array_flip($orderDetailsTempFields));

                if (isset($request['MPaxFirstName']) && isset($request['MPaxLastName'])) {
                    $data->put('PaxName', $request['MPaxFirstName'] . ' ' . $request['MPaxLastName']);
                }

                $data->put('DriverEmail', $this->driverEmail);

                $data->put('DriverTel', $this->driverTel);

                $firstOrderDetailsTemp->update($data->toArray());

                $allRecords['DetailsID_1'] = $firstOrderDetailsTemp->DetailsID;

            }
        }

        // UPDATE SECOND
        if ($updateReturn) {
            $secondOrderDetailsTemp = $orderMasterTemp->details->last();

            if ($secondOrderDetailsTemp->TNo == '2') {
                $data = collect($request)
                    ->mapWithKeys(function ($val, $key) {
                        return [ltrim($key, 'X') => $val];
                    })
                    ->intersectByKeys(array_flip($orderDetailsTempFields));

                if (isset($request['MPaxFirstName']) && isset($request['MPaxLastName'])) {
                    $data->put('PaxName', $request['MPaxFirstName'] . ' ' . $request['MPaxLastName']);
                }

                $data->put('DriverEmail', $this->driverEmail);

                $data->put('DriverTel', $this->driverTel);

                $secondOrderDetailsTemp->update($data->toArray());

                $allRecords['DetailsID_2'] = $secondOrderDetailsTemp->DetailsID;
            }
        }

        // ADD FIRST - mandatory
        if ($addFirst) {
            $data = collect($request)->intersectByKeys(array_flip($orderDetailsTempFields));

            $data->put('OrderID', $orderMasterTemp->MOrderID);

            $data->put('TNo', 1);

            if (isset($request['MPaxFirstName']) && isset($request['MPaxLastName'])) {
                $data->put('PaxName', $request['MPaxFirstName'] . ' ' . $request['MPaxLastName']);
            }

            $returnDetails = OrderDetailsTemp::create($data->toArray());

            $allRecords['DetailsID_1'] = $returnDetails->DetailsID;
        }

        // ADD RETURN
        if ($addReturn) {
            $data = collect($request)
                ->mapWithKeys(function ($val, $key) {
                    return [ltrim($key, 'X') => $val];
                })
                ->intersectByKeys(array_flip($orderDetailsTempFields));
            $data->put('OrderID', $orderMasterTemp->MOrderID);
            $data->put('TNo', 2);

            if (isset($request['MPaxFirstName']) && isset($request['MPaxLastName'])) {
                $data->put('PaxName', $request['MPaxFirstName'] . ' ' . $request['MPaxLastName']);
            }

            $data->put('DriverEmail', $this->driverEmail);
            $data->put('DriverTel', $this->driverTel);

            $returnDetails = OrderDetailsTemp::create($data->toArray());

            $allRecords['DetailsID_2'] = $returnDetails->DetailsID;
        }

        // DELETE RETURN
        if ($deleteReturn) {
            $orderMasterTemp->details->last()->extras()->delete();

            $orderMasterTemp->details->last()->delete();

            $allRecords['DetailsID_2'] = 'ReturnDeleted';
        }

        return $allRecords;
    }

    private function getDriverDetails($DriverID)
    {
        $driver = AuthUser::find($DriverID);

        $this->driverEmail = $driver->AuthUserMail;

        $this->driverTel = $driver->AuthUserTel;
    }

    private function getTableFields(string $class)
    {
        return Schema::getColumnListing(with(new $class)->getTable());
    }

    /**
     * @param  int  $detailsCount
     * @param       $returnTransfer
     *
     * @return array
     */
    private function handle($detailsCount, $returnTransfer)
    {
        $updateFirst = false;
        $updateReturn = false;
        $addFirst = false;
        $addReturn = false;
        $deleteReturn = false;

        // just one transfer found, update
        if ($detailsCount == 1 and $returnTransfer == 0) {
            $updateFirst = true;
        }

        // two transfers found, update both
        if ($detailsCount == 2 and $returnTransfer == 1) {
            $updateFirst = true;
            $updateReturn = true;
        }

        // one found, return exists, but not added
        if ($detailsCount == 1 and $returnTransfer == 1) {
            $updateFirst = true;
            $addReturn = true;
        }

        // return transfer removed, update first, remove second
        if ($detailsCount == 2 and $returnTransfer == 0) {
            $updateFirst = true;
            $deleteReturn = true;
        }

        // one or both are new
        if ($detailsCount == 0 and $returnTransfer == 0) {
            $addFirst = true;
            $addReturn = false;
        }
        if ($detailsCount == 0 and $returnTransfer == 1) {
            $addFirst = true;
            $addReturn = true;
        }

        return [$updateFirst, $updateReturn, $addFirst, $addReturn, $deleteReturn];
    }
}

function preg_grep_keys($pattern, $input, $flags = 0)
{
    return array_filter($input, function ($key) use ($pattern, $flags) {
        return preg_match($pattern, $key, $flags);
    }, ARRAY_FILTER_USE_KEY);
}
