<?php

namespace App\Http\Controllers\Api;

use App\Services\CouponService;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CouponController extends Controller
{
    /**
     * @var CouponService
     */
    private $service;
    
    
    /**
     * @param CouponService $service
     */
    public function __construct(CouponService $service)
    {
        $this->service = $service;
    }
    
    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function index(Request $request): JsonResponse
    {
        $coupon = $this->service->check($request->all());
        
        return response()->json([
            'is_valid' => $coupon['value'] > 0,
            'value' => $coupon['value'],
            'text' => $coupon['description']
        ]);
    }
    
    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function updateCount(Request $request): JsonResponse
    {
        $this->service->increment($request->coupon_code);
        
        return response()->json();
    }
}
