<?php

namespace App\Http\Controllers\Api;

use App\Mail\SendQuote;
use App\Mail\EmailQuote;
use App\Models\OrderMaster;
use App\Services\TempToLive;
use App\Services\CarsService;
use App\Models\OrderMasterTemp;
use App\Mail\SendQuoteToCustomer;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class EmailQuoteController extends Controller
{
    public function index()
    {
        Mail::to(request()->sendTo)->send(new EmailQuote(request()->all(), CarsService::get()));
        
        return response()->json([
            'message' => __('carPanel.emailQuoteSent')
        ]);
    }
    
    public function getTransferQuote()
    {
        $validator = Validator::make(request()->all(), [
            'name'  => 'required',
            'email' => 'required',
            'phone' => 'required'
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'message' => 'Please fill-in all data and press Get Quote',
            ], 422);
        }
    
        $request = request()->all();
        
        $request['TOK'] = request()->header('tok');
    
        $masterTemp = OrderMasterTemp::with('details')->where('MOrderKey', $request['TOK'])->first();
    
        $masterTemp->MPaymentMethod = 0;
        $masterTemp->MOrderStatus = 6;
        $masterTemp->MPaxLastName = $request['name'];
        $masterTemp->MPaxEmail = $request['email'];
        $masterTemp->MPaxTel = $request['phone'];
        $masterTemp->save();
    
        $masterTemp->details->each(function ($detail, $key) use ($request) {
            $detail->PaxNo = $request['passengers'];
            $detail->PaxName = $request['name'];
            $detail->TransferStatus = 6;
            $detail->FlightNo = $key == 1 ? $request['XFlightNumber'] : $request['flightNumber'];
            $detail->save();
        });
    
        Mail::to(env('MAIL_FROM_ADDRESS'))
            ->send(new SendQuote($request));
    
        Mail::to($request['email'])
            ->send(new SendQuoteToCustomer($request));
        
        return response()->json([
            'message' => 'Thank you! We will reply shortly.',
        ]);
    }
    
    public function tempToLive(TempToLive $tempToLive)
    {
        $tok = request()->tok;
        
//        session(['TOK' => $tok]);
        
        // check for tok in db...
        if (!OrderMasterTemp::where('MOrderKey', $tok)->exists()) {
            return 'Can not find order';
        }
        
        // check if already live...
        if ($orderMaster = OrderMaster::with('details')->where('MCardNumber', $tok)->first()) {
            return redirect('https://cms.jamtransfer.com/cms/index.php?p=editActiveTransfer&rec_no=' . $orderMaster->details->first()->DetailsID);
        }
        
        // temp to live...
        $t = $tempToLive->execute($tok);

        return redirect('https://cms.jamtransfer.com/cms/index.php?p=editActiveTransfer&rec_no=' . $t->details->first()->DetailsID);
    }
}
