<?php

namespace App\Http\Middleware;

use App\Library\ClassPassHelper;
use App\Models\SiteToken;
use Closure;
use Illuminate\Http\Request;

class SetCountryId
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // todo: maybe this is not necessary
        $countryId = $request->header('X-Country');
        if ($countryId) {
            config(['id_country' => $countryId]);

            return $next($request);
        } else {
            return response()->json(
                ['errors' => [['message' => 'Country not supported', 'status_code' => 401]]],
                401
            );
        }
    }
}
