<?php

namespace App\Mail;

use App\Services\PDF;
use App\Services\PdfParser;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class DriverConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public $orderMaster;

    /**
     * Create a new message instance.
     *
     * @param       $orderMaster
     */
    public function __construct($orderMaster)
    {
        $this->orderMaster = $orderMaster;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(__('newTransfer') . ' - ' . $this->orderMaster->MOrderKey . '-' . $this->orderMaster->MOrderID)
                    ->from([
                        'address' => 'driver-info@jamtransfer.com',
                        'name'    => 'JamTransfer',
                    ])
                    ->replyTo('info@jamtransfer.com')
                    ->view('emails.driverConfirmation')
                    ->with(['footer' => PdfParser::pdfFooter('3')]);
    }
}
