<?php

namespace App\Mail;

use App\Models\AuthUser;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Order extends Mailable
{
    use Queueable, SerializesModels;

    public $orderMaster;

    public $voucher;

    /**
     * Create a new message instance.
     *
     * @param $orderMaster
     * @param $voucher
     */
    public function __construct($orderMaster, $voucher)
    {
        $this->orderMaster = $orderMaster;
        $this->voucher = $voucher;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $coData = AuthUser::find('53');

        return $this->subject('Confirmation for ' . $this->orderMaster->MOrderKey . '-' . $this->orderMaster->MOrderID)
                    ->from([
                        'address' => 'confirmation@jamtransfer.com',
                        'name'    => $coData->AuthUserCompany,
                    ])
                    ->replyTo($coData->AuthUserMail)
                    ->view('emails.confirmation')
                    ->attach('./pdf/' . $this->orderMaster->MOrderID . '.pdf');
    }
}
