<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderDetails extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'v4_OrderDetails';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'DetailsID';

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public function master()
    {
        return $this->belongsTo(OrderMaster::class, 'OrderID', 'MOrderID');
    }

    /**
     * OrderDetails has many extras
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function extras()
    {
        return $this->hasMany(OrderExtras::class, 'OrderDetailsID', 'DetailsID');
    }

    public function driver()
    {
        return $this->belongsTo(AuthUser::class, 'DriverID', 'AuthUserID');
    }

    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class, 'VehicleType', 'VehicleTypeID');
    }
}
