<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderDetailsTemp extends Model
{
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'v4_OrderDetailsTemp';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'DetailsID';

    /**
     * The model's attributes.
     *
     * @var array
     */
    protected $attributes = [
        'PickupPlace'      => '',
        'PickupAddress'    => '',
        'DropPlace'        => '',
        'DropNotes'        => '',
        'DriverConfDate'   => '',
        'DriverConfTime'   => '',
        'DriverConfStatus' => 0,
        'DriverNotes'      => '',
        'PriceClassID'     => 0,
        'Rated'            => '',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function extras()
    {
        return $this->hasMany(OrderExtrasTemp::class, 'OrderDetailsID', 'DetailsID');
    }

    public function setDropAddressAttribute($value)
    {
        $this->attributes['DropAddress'] = $value ?? '';
    }

    public function setPickupNotesAttribute($value)
    {
        $this->attributes['PickupNotes'] = $value ?? '';
    }
}
