<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Route;
use App\Models\Rating;
use App\Models\Service;
use App\Models\Vehicle;
use App\Models\AuthUser;
use App\Models\SurRoute;
use App\Models\SurGlobal;
use App\Models\SurVehicle;
use App\Models\SurService;
use App\Models\SpecialDate;
use App\Models\VehicleType;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class CarsService
{
    /*
    napomena za Surcharges:
    0 - nema
    1 - global + OwnerID
    2 - route + OwnerID + RouteID
    3 - vehicle + OwnerID + VehicleID
    4 - service + OwnerID + ServiceID

    Podatak se nalazi u SurCategory polju, plus ova ostala polja za lookup.

    Logika je:
    - ako je u Services SurCategory 0,
    - pogledaj u Vehicles. Ako je i tamo nula,
    - pogledaj u Routes. Ako je i tamo nula,
    - pogledaj u SurGlobal

    Ovo bi trebalo pametnije rijesit.
    Kod odabira surcharges bi trebalo u sve upisat kategoriju.
    Npr. ako vozac na profilu stavi Global, onda bi u sva njegova vozila, rute i services
    trebalo odmah upisat 1.
    Ako kasnije na neku rutu stavi Route surcharges, onda bi u sve Services za tu rutu
    trebalo upisat 2.
    Ako stavi samo za neko vozilo, onda bi u sve Services za to vozilo trebalo stavit 3.
    Ako stavi samo za jednu uslugu, onda tu ide 4.

    Tako bi se odmah moglo znat di triba gledat.

    Ako nesto kasnije promijeni, postupak bi treba bit isti.
    Npr. ako za neko vozilo stavi da nema surcharges, a prije je bilo,
    onda bi za sve Services od toga vozila trebalo stavit 0, ako je prije bilo 3.
    Ako je bilo 4, onda ne dirat.


*/

    public static function get($transfer = null)
    {
        error_reporting(0);
        //        define("DEBUG", 0);
        $_SERVER['DOCUMENT_ROOT'] = 'C:\Users\Jam Transfer\Desktop\jam';

        //        require_once $_SERVER['DOCUMENT_ROOT'] . '/f2/f.php';
//        require_once $_SERVER['DOCUMENT_ROOT'] . '/db/db.class.php';


        //        @Blogit('getCars request/session');
        //@Blogit($_REQUEST);


        $returnTransfer = 0;
        $T = $transfer ?: BookingDataService::get();
//        $T = BookingData::get(); // vrati ako ne valja, samo zbog testiranja saljem transfer u ovu funkciju iz BookingController-a
        if (count($T) > 2) {
            $returnTransfer = 1;
        }

        // Request u varijable
        // ako se kasnije nesto promijeni, ovako je lakse

        $FromID = $T[0]['PickupID'];
        $ToID = $T[0]['DropID'];
        $PaxNo = $T[0]['PaxNo'];

        $transferDate = $T[0]['PickupDate'];
        $transferTime = $T[0]['PickupTime'];

        if ($returnTransfer == 1) {
            $returnDate = $T[1]['PickupDate'];
            $returnTime = $T[1]['PickupTime'];
        } else {
            $returnTransfer = 0;
            $returnDate = '';
            $returnTime = '';
        }

        //        @Blogit($_SESSION);

        // Izlazni podaci koje koriste skripte za display
        $cars = []; // podaci o vozilima
        $drivers = []; // podaci o vozacima
        $carsErrorMessage = ["greska"]; // greske

        $route = Route::with([
            'driverRoutes' => function ($query) {
                $query->where('Active', 1);
            },
        ])
                      ->where(function ($query) use ($FromID, $ToID) {
                          $query->where('FromID', $FromID)->where('ToID', $ToID);
                      })
                      ->orWhere(function ($query) use ($FromID, $ToID) {
                          $query->where('FromID', $ToID)->where('ToID', $FromID);
                      })->first();

        if (! $route) {
            $carsErrorMessage['title'] = $ROUTE_NOT_FOUND;
            $carsErrorMessage['text'] = $CHECK_FROM_TO;
        } else {
            $km = $route->Km;
            $duration = $route->Duration;

            if ($route->driverRoutes->count() == 0) {
                $carsErrorMessage['title'] = $NO_DRIVERS;
                $carsErrorMessage['text'] = $NO_DRIVERS_EXT;
            } else {

                foreach ($route->driverRoutes as $driverRoute) {
                    if ($driverRoute->FromID == $FromID and $driverRoute->OneToTwo == '0') {
                        continue;
                    }


                    if ($driverRoute->FromID == $ToID and $driverRoute->TwoToOne == '0') {
                        continue;
                    }

                    if ($returnTransfer) {
                        if ($driverRoute->ToID == $FromID and $driverRoute->OneToTwo == '0') {
                            continue;
                        }

                        if ($driverRoute->ToID == $ToID and $driverRoute->TwoToOne == '0') {
                            continue;
                        }
                    }

                    $ownerId = $driverRoute->OwnerID;

                    $authUser = AuthUser::find($ownerId);
                    if (! $authUser) {
                        break;
                    }


                    // racunanje preostalog vremena do transfera
                    $dt = explode('-', $transferDate);
                    $tm = explode(':', $transferTime);
                    $restHours = (mktime($tm[0], $tm[1], 0, $dt[1], $dt[2], $dt[0]) - time()) / 3600;

                    // da li je setovano raspolozivo vreme za transfer
//                    $transferTime = $authUser->Temp_pass_active > 0 ? $authUser->Temp_pass_active : 14;

                    if (($authUser->Temp_pass_active > 0 ? $authUser->Temp_pass_active : 14) > $restHours) {
                        continue;
                    }

                    // Driver Profiles iz v4_AuthUsers
                    //$Driver = $au->getAuthUserName();
                    $DriverCompany = $authUser->AuthUserCompany;
                    $ProfileImage = 'http://team.taxido.net/' . $authUser->Image;
                    if ($authUser->Image == '') {
                        $ProfileImage = 'i/noImage.png';
                    }

                    // check for Services
                    $services = Service::where('RouteID', $route->RouteID)
                                       ->where('OwnerID', $ownerId)
                                       ->where('Active', 1)
                                       ->orderBy('ServiceID')
                                       ->get();

                    if ($services->count() == 0) { // not found
                        $carsErrorMessage['title'] = $NO_VEHICLES;
                        $carsErrorMessage['text'] = $NO_VEHICLES_EXT;
                    } else { // found
                        foreach ($services as $service) {
                            $ServiceID = $service->ServiceID;

                            $Correction = $service->Correction;

                            $vehicle = Vehicle::find($service->VehicleID);

                            $VehicleName = getVehicleTypeName($vehicle->VehicleTypeID);
                            $aaa = getVehicleMaxPax($vehicle->VehicleTypeID);
                             Log::emergency("broj putnika: $aaa");


                            $VehicleTypeID = $vehicle->VehicleTypeID;
                            $VehicleCapacity = $vehicle->VehicleCapacity;
                            $WiFi = $vehicle->AirCondition;
                            $VehicleImage = $vehicle->VehicleImage;
                            $VehicleID = $vehicle->VehicleID;
                            $ReturnDiscount = $vehicle->ReturnDiscount;
                            $VehicleImageRoot = "http://" . $_SERVER['HTTP_HOST'];

                            $vehicleType = VehicleType::find($VehicleTypeID);

                            $VehicleClass = $vehicleType->VehicleClass;
                            $VehicleDescription = getVehicleDescription($vehicle->VehicleTypeID); // do 2017-11-23 je bilo $vt->getDescription(); -R

                            if ($VehicleImage != "") {
                                $VehicleImage = "/cms/" . $VehicleImage;
                                $vehicleImageFile = $VehicleImage;
                            }     // ukoliko u redu tabele ima slika
                            else { //ukoliko je nema
                                if ($VehicleClass == '1') {
                                    $vehicleImageFile = '/i/cars/sedan.png';
                                } else {
                                    if ($VehicleClass == '2') {
                                        $vehicleImageFile = '/i/cars/minivanl.png';
                                    } else {
                                        if ($VehicleClass == '3') {
                                            $vehicleImageFile = '/i/cars/minibusl.png';
                                        } else {
                                            if ($VehicleClass == '4') {
                                                $vehicleImageFile = '/i/cars/minibusl.png';
                                            } else {
                                                if ($VehicleClass == '5' or $VehicleClass == '6') {
                                                    $vehicleImageFile = '/i/cars/bus.png';
                                                } else {
                                                    if ($VehicleClass == '11') {
                                                        $vehicleImageFile = '/i/cars/sedan_p.png';
                                                    } else {
                                                        if ($VehicleClass == '12') {
                                                            $vehicleImageFile = '/i/cars/minivans_p.png';
                                                        } else {
                                                            if ($VehicleClass == '13') {
                                                                $vehicleImageFile = '/i/cars/minivans_p.png';
                                                            } else {
                                                                if ($VehicleClass == '14') {
                                                                    $vehicleImageFile = '/i/cars/minibusl_p.png';
                                                                } else {
                                                                    if ($VehicleClass == '15' or $VehicleClass == '16') {
                                                                        $vehicleImageFile = '/i/cars/bus_p.png';
                                                                    } else {
                                                                        if ($VehicleClass == '21') {
                                                                            $vehicleImageFile = '/i/cars/sedan_l.png';
                                                                        } else {
                                                                            if ($VehicleClass == '22') {
                                                                                $vehicleImageFile = '/i/cars/minivans_l.png';
                                                                            } else {
                                                                                if ($VehicleClass == '23') {
                                                                                    $vehicleImageFile = '/i/cars/minivanl_l.png';
                                                                                } else {
                                                                                    if ($VehicleClass == '24') {
                                                                                        $vehicleImageFile = '/i/cars/minibusl_l.png';
                                                                                    } else {
                                                                                        if ($VehicleClass == '25' or $VehicleClass == '26') {
                                                                                            $vehicleImageFile = '/i/cars/bus_l.png';
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            $VehicleImage = $vehicleImageFile;

                            /*

                                    Ovdje upada dio sa izracunavanjem cijena ovisno o:
                                    - return discount
                                    - danu u tjednu
                                    - sezoni
                                    - je li nocna voznja

                                    Sve te faktore treba prikazati kupcu kao dodatak na osnovnu cijenu.
                                    Ako je Return transfer, Surcharges vraca zbrojene dodatke za oba transfera!

                                */
                            $SurCategory = $service->SurCategory;

                            $DRSurCategory = $driverRoute->SurCategory;
                            $VSurCategory = $vehicle->SurCategory;

                            $sur = Surcharges($ownerId, $SurCategory, $service->ServicePrice1,
                                $transferDate, $transferTime,
                                $returnDate, $returnTime,
                                $driverRoute->ID, $VehicleID, $ServiceID,
                                $VSurCategory, $DRSurCategory
                            );

                            $addToPrice = $sur['MonPrice'] +
                                $sur['TuePrice'] +
                                $sur['WedPrice'] +
                                $sur['ThuPrice'] +
                                $sur['FriPrice'] +
                                $sur['SatPrice'] +
                                $sur['SunPrice'] +
                                $sur['S1Price'] +
                                $sur['S2Price'] +
                                $sur['S3Price'] +
                                $sur['S4Price'] +
                                $sur['S5Price'] +
                                $sur['S6Price'] +
                                $sur['S7Price'] +
                                $sur['S8Price'] +
                                $sur['S9Price'] +
                                $sur['S10Price'] +
                                $sur['NightPrice'];

                            if ($returnTransfer) {
                                // vozaceva osnovna cijena za jedan smjer
                                $DriversPrice = $service->ServicePrice1;

                                // izracun popusta na Return transfer
                                $DiscountPrice = $DriversPrice - ($DriversPrice * $ReturnDiscount / 100);

                                // finalna cijena vozaca za Return transfer sa svim odbicima i dodacima
                                $DriversPrice = $DriversPrice + $DiscountPrice + $addToPrice;
                                $specialDatesPrice = calculateSpecialDates($ownerId, $DriversPrice/2, $transferDate, $transferTime, $returnDate, $returnTime);

                                $DriversPrice = $DriversPrice + $specialDatesPrice;

                                // OneWay Price
                                $OneWayPrice = ($DriversPrice) / 2;
                                $OneWayPrice = calculateBasePrice($OneWayPrice, $service->OwnerID, $VehicleClass);

                                // na finalnu cijenu vozaca dodaj proviziju
                                $FinalPrice = calculateBasePrice($DriversPrice, $service->OwnerID, $VehicleClass);
                                // zbog kasnijeg cuvanja i bazi i deljenja potrebno je zaokruzenje polovine cene return transfera pa dupliranje
                                $FinalPrice = nf(round($FinalPrice / 2, 2)) * 2;
                            } else {
                                // inace je jedan smjer, pa dodaci idu odmah
                                $DriversPrice = $service->ServicePrice1;
                                $DriversPrice = $DriversPrice + $addToPrice;


                                $specialDatesPrice = calculateSpecialDates($ownerId, $DriversPrice, $transferDate, $transferTime);

                                $DriversPrice = $DriversPrice + $specialDatesPrice;
                                $OneWayPrice = calculateBasePrice($DriversPrice, $service->OwnerID, $VehicleClass);
                                $FinalPrice = $OneWayPrice;


                            }


                            // zaokruzenje cijena
                            //$FinalPrice = nf( round($FinalPrice,0,PHP_ROUND_HALF_UP) );
                            $FinalPrice = nf(round($FinalPrice, 2));

                            /*
                            ** KRAJ OBRADE CIJENA
                            */

                            // premjesteno od dole, tako da se upoce ne uzimaju u obzir podaci
                            // ako vozac nije aktivan ili ne vozi odredjene datume
                            $okToAdd = true;
                            # nemoj dodati cijene ako driver nije Active!!!
                            if ($authUser->Active == 0) {
                                $okToAdd = false;
                            }

                            # nemoj dodati cijene ako je osnovna cena 0
                            if ($service->ServicePrice1 == 0) {
                                $okToAdd = false;
                            }

                            if (isVehicleOffDuty($VehicleID, $transferDate, $transferTime)) {
                                $okToAdd = false;
                            }

                            $vehicleNumber = ceil(($PaxNo / $VehicleCapacity));

                            if ($vehicleNumber > 5) {
                                $okToAdd = false;
                            }
                            if ($returnDate != '') {
                                if (isVehicleOffDuty($VehicleID, $returnDate, $returnTime)) {
                                    $okToAdd = false;
                                }
                            }
                            // sortiranje top drivera ispred ostalih
                            // kako mora biti sortirano i po cijeni
                            // onda se cijena mnozi sa 11-rating (tako da ako je rating 10, mnozi se sa 1)
                            // znaci ako je rating veci, rating cijena je manja
                            // pa vozac izlazi ispred
                         //   $Rating = $FinalPrice * (11 - ShowRatings($ownerId));
                       //     Log::emergency($okToAdd);


                            // ako je vozilo dovoljno veliko,
                            // spremi podatke i profil
                            // if ($VehicleCapacity >= $PaxNo and $okToAdd == true)
                            if ($okToAdd == true) {
                                // Za isti tip vozila prikazi samo najpovoljniju cijenu
                                $keyFound = '';

                                foreach ($cars as $key => $niz) {
                                    if ($niz['VehicleTypeID'] == $VehicleTypeID and $niz['FinalPrice'] > 0) {
                                        $keyFound = $key;

                                        break;
                                    }
                                }


                                if ($keyFound !== '') {
                                    if (count($cars) > 0) {
                                        if ($FinalPrice > 0) {
                                            if ($cars[$keyFound]['VehicleTypeID'] == $VehicleTypeID) {
                                                if ($cars[$keyFound]['FinalPrice'] > $FinalPrice) {// izbaci skuplje
                                                    unset($cars[$keyFound]);
                                                    $okToAdd = true;
                                                } else {
                                                    if ($FinalPrice > $cars[$keyFound]['FinalPrice']) {
                                                        $okToAdd = false;
                                                        //logit('Izbaceno-prvi');

                                                    } else {
                                                        if ($FinalPrice == $cars[$keyFound]['FinalPrice']) {
                                                            $okToAdd = false;
                                                            //logit('Izbaceno-drugi');
                                                        }
                                                    }
                                                }
                                            } else {
                                                $okToAdd = true;
                                            }
                                        } else {
                                            $okToAdd = false;
                                        }
                                    }
                                }

                                if ($FinalPrice == 0) {
                                    $okToAdd = false;
                                }

                                if ($okToAdd) {

                                    $sortHelpClass = 1000 + $VehicleClass;
                                    $sortHelpCapacity = 1000 + $VehicleCapacity;
                                    //$sortBy = $sortHelpCapacity . $sortHelpClass;
                                    $sortBy = $vehicleNumber.$sortHelpCapacity . $sortHelpClass;
									
								//	$sortBy = $vehicleNumber * $FinalPrice;

                                    $cars[] = [
                                        'RouteID'            => $route->RouteID,
                                        'OwnerID'            => $ownerId,
                                        'DriverCompany'      => $DriverCompany,
                                        'ProfileImage'       => $ProfileImage,
                                        'ServiceID'          => $ServiceID,
                                        'VehicleID'          => $VehicleID,
                                        'VehicleTypeID'      => $VehicleTypeID,
                                        'VehicleName'        => $VehicleName,
                                        'VehicleImage'       => $VehicleImage,
                                        'VehicleCapacity'    => $VehicleCapacity,
                                        'VehicleClass'       => $VehicleClass,
                                        'WiFi'               => $WiFi,
                                        'VehicleSort'        => $sortBy,
                                        'VehicleDescription' => $VehicleDescription,
                                        'FinalPrice'         => nf($FinalPrice),
                                        'FinalPriceValue'    => nf($FinalPrice*$vehicleNumber),
                                        // cijena sa svim dodacima
                                        'DriversPrice'       => nf($DriversPrice),
                                        // cista vozacka cijena
                                        'OneWayPrice'        => nf($OneWayPrice),
                                        // cijena za jedan smjer sa dodacima
                                      //  'Rating'             => $Rating,
                                        'NightPrice'         => $sur['NightPrice'],
                                        'MonPrice'           => $sur['MonPrice'],
                                        'TuePrice'           => $sur['TuePrice'],
                                        'WedPrice'           => $sur['WedPrice'],
                                        'ThuPrice'           => $sur['ThuPrice'],
                                        'FriPrice'           => $sur['FriPrice'],
                                        'SatPrice'           => $sur['SatPrice'],
                                        'SunPrice'           => $sur['SunPrice'],
                                        'S1Price'            => $sur['S1Price'],
                                        'S2Price'            => $sur['S2Price'],
                                        'S3Price'            => $sur['S3Price'],
                                        'S4Price'            => $sur['S4Price'],
                                        'S5Price'            => $sur['S5Price'],
                                        'S6Price'            => $sur['S6Price'],
                                        'S7Price'            => $sur['S7Price'],
                                        'S8Price'            => $sur['S8Price'],
                                        'S9Price'            => $sur['S9Price'],
                                        'S10Price'           => $sur['S10Price'],
                                        'Km'                 => $km,
                                        'Duration'           => $duration,
                                        'PaxNo' => $PaxNo
                                    ];

                                    // ako Driver ima odgovarajuce vozilo,
                                    // popuni podatke o profilu
                                    // Driver Profiles iz v4_AuthUsers
                                    $drivers[$ownerId] = [
                                        'DriverCompany' => $DriverCompany,
                                        'ProfileImage'  => $ProfileImage,
                                        'RealName'      => $authUser->AuthUserRealName,
                                        'Company'       => $authUser->AuthUserCompany,
                                        'Address'       => $authUser->AuthCoAddress,
                                    ];
                                }
                            }
                        }
                    }
                }
            }
        }

        if (count($cars) == 0) {
            $carsErrorMessage['title'] = $NO_VEHICLES;
            $carsErrorMessage['text'] = $TOO_SMALL;
        } else {

            $carsErrorMessage = []; // reset arraya za greske

            $sort1 = subval_sort($cars, 'VehicleSort');
            $sort2 = subval_sort($cars, 'FinalPriceValue');

            $bestPrice = $sort2[0]['ServiceID'];

            $cars = [];

            $cars[] = $sort2[0];

            foreach ($sort1 as $key => $arr) {
                if ($sort1[$key]['ServiceID'] != $bestPrice) {
                    $cars[] = $sort1[$key];
                }
            }

            return collect($cars);
        }
    }

    private static function isBlackFriday($transfer, $ownerId)
    {
        if (
            isBlackFriday() &&
            (in_array($transfer[0]['PickupID'], config('blackFriday.terminals')) || in_array($transfer[0]['DropID'], config('blackFriday.terminals'))) &&
            Carbon::parse($transfer[0]['PickupDate'])->isBetween(config('blackFriday.season.start'), config('blackFriday.season.end'))
        ) {
            if (!in_array($ownerId, config('blackFriday.drivers'))) {
                return false;
            }
        }

        return true;
    }
}

function ShowRatings($userId)
{
    $rating = Rating::where('OwnerID', $userId)->first();

    if ($rating->Votes > 0) {
        return $rating->Average / $rating->Votes;
    }

    return 0;
}

function inDateTimeRange($dateStart, $time_start, $dateEnd, $time_end, $dateNeedle, $time_needle)
{
    $res = false;
    $t1 = strtotime("{$dateStart} {$time_start}:00");
    $t2 = strtotime("{$dateEnd} {$time_end}:00");
    $tn = strtotime("{$dateNeedle} {$time_needle}:00");
    //if ($t1 >= $t2) $t2 = strtotime('+1 day', $t2);
    //if ($tn <= $t1) $tn = strtotime('+1 day', $tn);
    if (($tn >= $t1) && ($tn <= $t2)) {
        return true;
    } // or return ($tn > $t1) && ($tn < $t2);
    else {
        return false;
    }
}

function inDateRange($start, $end, $needle)
{
    if (empty($start)) {
        return false;
    }
    if (empty($end)) {
        return false;
    }
    if (empty($needle)) {
        return false;
    }

    $parts = explode('-', $needle);
    $year = $parts[0];

    $fullStart = $year . '-' . $start;
    $fullEnd = $year . '-' . $end;

    if ($fullStart < $fullEnd) {
        return ($needle >= $fullStart) && ($needle <= $fullEnd);
    }
    if ($fullStart > $fullEnd) {
        $fullEnd = $year + 1 . '-' . $end;
        return ($needle >= $fullStart) && ($needle <= $fullEnd);
    }
    if ($fullStart == $fullEnd) {
        return ($needle == $fullStart) && ($needle == $fullEnd);
    }
}

# sort 2-d arraya
function subval_sort($a, $subkey)
{
    foreach ($a as $k => $v) {
        $b[$k] = strtolower($v[$subkey]);
    }
    asort($b);
    foreach ($b as $key => $val) {
        $c[] = $a[$key];
    }

    return $c;
}

function getVehicleDescription($vehicleTypeId)
{
    return VehicleType::find($vehicleTypeId)->{'Description' . Lang()};
}

// izracun dodataka na cijene za booking formu
function Surcharges(
    $OwnerID, $SurCategory, $base, $tDate, $tTime, $rDate = '', $rTime = '',
    $RouteID = '', $VehicleID = '', $ServiceID = '',
    $VSurCategory = '', $DRSurCategory = ''
) {

    // Variables
    $sur = [
        'NightPrice' => 0,
        'MonPrice'   => 0,
        'TuePrice'   => 0,
        'WedPrice'   => 0,
        'ThuPrice'   => 0,
        'FriPrice'   => 0,
        'SatPrice'   => 0,
        'SunPrice'   => 0,
        'S1Price'    => 0,
        'S2Price'    => 0,
        'S3Price'    => 0,
        'S4Price'    => 0,
        'S5Price'    => 0,
        'S6Price'    => 0,
        'S7Price'    => 0,
        'S8Price'    => 0,
        'S9Price'    => 0,
        'S10Price'   => 0,

    ];
    $owp = 0;
    $rp = 0;

    $finished = false;

    for ($i = 1; $i <= 4; $i++) {

        if (! $finished) {

            switch ($i) {
                case '4':
                    $sc = SurGlobal::where('OwnerID', $OwnerID)->first();

                    break;
                case '2':
                    $sc = SurVehicle::where('OwnerID', $OwnerID)->where('VehicleID', $VehicleID)->first();

                    break;
                case '3':
                    $sc = SurRoute::where('OwnerID', $OwnerID)->where('DriverRouteID', $RouteID)->first();

                    break;
                case '1':
                    $sc = SurService::where('OwnerID', $OwnerID)->where('ServiceID', $ServiceID)->first();

                    break;
            }

            if (
                // service surcharges
                ($i == 1 and $SurCategory == 4) or
                // route surcharges
                ($i == 3 and $DRSurCategory == 3) or
                // vehicle surcharges
                ($i == 2 and $VSurCategory == 2) or

                // global surcharges
                (($i == 4 and $SurCategory == 1) and
                    ($i == 4 and $VSurCategory == 1) and
                    ($i == 4 and $DRSurCategory == 1))
            ) {
                // trazimo samo dodatke na osnovnu cijenu, ne i konacne cijene!
                // zato je na kraju -base

                if (inTimeRange($sc->NightStart, $sc->NightEnd, $tTime)) {
                    $owp = calcAddPrice($base, $sc->NightPercent, $sc->NightAmount);
                }
                if ($rTime != '') {
                    if (inTimeRange($sc->NightStart, $sc->NightEnd, $rTime)) {
                        $rp = calcAddPrice($base, $sc->NightPercent, $sc->NightAmount);
                    }
                }
                $sur['NightPrice'] = ($owp + $rp);
                $owp = $rp = 0;

                // Monday
                if (date("w", strtotime($tDate)) == 1) {
                    $owp = calcAddPrice($base, $sc->MonPercent, $sc->MonAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 1) {
                        $rp = calcAddPrice($base, $sc->MonPercent, $sc->MonAmount);
                    }
                }
                $sur['MonPrice'] = ($owp + $rp);
                $owp = $rp = 0;


                // Tuesday
                if (date("w", strtotime($tDate)) == 2) {
                    $owp = calcAddPrice($base, $sc->TuePercent, $sc->TueAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 2) {
                        $rp = calcAddPrice($base, $sc->TuePercent, $sc->TueAmount);
                    }
                }
                $sur['TuePrice'] = ($owp + $rp);
                $owp = $rp = 0;


                // Wednesday
                if (date("w", strtotime($tDate)) == 3) {
                    $owp = calcAddPrice($base, $sc->WedPercent, $sc->WedAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 3) {
                        $rp = calcAddPrice($base, $sc->WedPercent, $sc->WedAmount);
                    }
                }
                $sur['WedPrice'] = ($owp + $rp);
                $owp = $rp = 0;


                // Thursday
                if (date("w", strtotime($tDate)) == 4) {
                    $owp = calcAddPrice($base, $sc->ThuPercent, $sc->ThuAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 4) {
                        $rp = calcAddPrice($base, $sc->ThuPercent, $sc->ThuAmount);
                    }
                }
                $sur['ThuPrice'] = ($owp + $rp);
                $owp = $rp = 0;

                // Friday
                if (date("w", strtotime($tDate)) == 5) {
                    $owp = calcAddPrice($base, $sc->FriPercent, $sc->FriAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 5) {
                        $rp = calcAddPrice($base, $sc->FriPercent, $sc->FriAmount);
                    }
                }
                $sur['FriPrice'] = ($owp + $rp);
                $owp = $rp = 0;

                // Saturday
                if (date("w", strtotime($tDate)) == 6) {
                    $owp = calcAddPrice($base, $sc->SatPercent, $sc->SatAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 6) {
                        $rp = calcAddPrice($base, $sc->SatPercent, $sc->SatAmount);
                    }
                }
                $sur['SatPrice'] = ($owp + $rp);
                $owp = $rp = 0;


                // Sunday
                if (date("w", strtotime($tDate)) == 0) {
                    $owp = calcAddPrice($base, $sc->SunPercent, $sc->SunAmount);
                }
                if ($rDate != '') {
                    if (date("w", strtotime($rDate)) == 0) {
                        $rp = calcAddPrice($base, $sc->SunPercent, $sc->SunAmount);
                    }
                }
                $sur['SunPrice'] = ($owp + $rp);
                $owp = $rp = 0;


                // Season 1
                if (inDateRange($sc->S1Start, $sc->S1End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S1Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S1Start, $sc->S1End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S1Percent, 0);
                    }
                }
                $sur['S1Price'] = ($owp + $rp);
                $owp = $rp = 0;


                // Season 2
                if (inDateRange($sc->S2Start, $sc->S2End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S2Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S2Start, $sc->S2End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S2Percent, 0);
                    }
                }
                $sur['S2Price'] = ($owp + $rp);
                $owp = $rp = 0;

                // Season 3
                if (inDateRange($sc->S3Start, $sc->S3End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S3Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S3Start, $sc->S3End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S3Percent, 0);
                    }
                }
                $sur['S3Price'] = ($owp + $rp);
                $owp = $rp = 0;

                // Season 4
                if (inDateRange($sc->S4Start, $sc->S4End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S4Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S4Start, $sc->S4End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S4Percent, 0);
                    }
                }
                $sur['S4Price'] = ($owp + $rp);
                $owp = $rp = 0;


                // Season 5
                if (inDateRange($sc->S5Start, $sc->S5End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S5Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S5Start, $sc->S5End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S5Percent, 0);
                    }
                }
                $sur['S5Price'] = ($owp + $rp);
                $owp = $rp = 0;


                // Season 6
                if (inDateRange($sc->S6Start, $sc->S6End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S6Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S6Start, $sc->S6End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S6Percent, 0);
                    }
                }
                $sur['S6Price'] = ($owp + $rp);
                $owp = $rp = 0;

                // Season 7
                if (inDateRange($sc->S7Start, $sc->S7End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S7Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S7Start, $sc->S7End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S7Percent, 0);
                    }
                }
                $sur['S7Price'] = ($owp + $rp);
                $owp = $rp = 0;

                // Season 8
                if (inDateRange($sc->S8Start, $sc->S8End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S8Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S8Start, $sc->S8End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S8Percent, 0);
                    }
                }
                $sur['S8Price'] = ($owp + $rp);
                $owp = $rp = 0;

                // Season 9
                if (inDateRange($sc->S9Start, $sc->S9End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S9Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S9Start, $sc->S9End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S9Percent, 0);
                    }
                }
                $sur['S9Price'] = ($owp + $rp);
                $owp = $rp = 0;

                // Season 10
                if (inDateRange($sc->S10Start, $sc->S10End, $tDate)) {
                    $owp = calcAddPrice($base, $sc->S10Percent, 0);
                }
                if ($rDate != '') {
                    if (inDateRange($sc->S10Start, $sc->S10End, $rDate)) {
                        $rp = calcAddPrice($base, $sc->S10Percent, 0);
                    }
                }
                $sur['S10Price'] = ($owp + $rp);
                $owp = $rp = 0;
            }
        } // endif SurCategory > 0
    }

    return $sur;
}

function inTimeRange($time_start, $time_end, $time_needle)
{
    $res = false;
    $t1 = strtotime("1970-01-01 {$time_start}:00");
    $t2 = strtotime("1970-01-01 {$time_end}:00");
    $tn = strtotime("1970-01-01 {$time_needle}:00");
    if ($t1 >= $t2) {
        $t2 = strtotime('+1 day', $t2);
    }
    if ($tn <= $t1) {
        $tn = strtotime('+1 day', $tn);
    }
    return ($tn >= $t1) && ($tn <= $t2); // or return ($tn > $t1) && ($tn < $t2);
}

function calcAddPrice($base, $percent, $amount = 0)
{
    $add = $base * $percent / 100;
    if ($amount == 0) {
        return number_format($add, 2, '.', '');
    }
    if ($percent == 0) {
        return number_format($amount, 2, '.', '');
    }
}

// Dodavanje dogovorene provizije na osnovnu cijenu
function calculateBasePrice($price, $ownerid, $VehicleClass = 1)
{
    // ako je u decimalama, zaokruzi na cijeli broj
    // npr. 299.20 treba zaokruziti na 299 radi toga sto su usporedne cijene na cijeli broj
    // 100-299, pa onda 300-9999
    // pa ako se ide usporediti onda je 299.20 vece od 299, ali je i manje od 300
    // i onda nece upasti ni u jedan if
    $priceR = round($price, 0, PHP_ROUND_HALF_DOWN);

    $driver = AuthUser::find($ownerid);

    if ($driver) {

        // STANDARD CLASS
        if ($VehicleClass < 11) {
            if ($priceR >= $driver->R1Low and $priceR < $driver->R2Low) {
                return $price + ($price * $driver->R1Percent / 100);
            } else {
                if ($priceR >= $driver->R2Low and $priceR < $driver->R3Low) {
                    return $price + ($price * $driver->R2Percent / 100);
                } else {
                    return $price + ($price * $driver->R3Percent / 100);
                }
            }
        }

        // PREMIUM CLASS
        if ($VehicleClass >= 11 and $VehicleClass < 21) {
            if ($priceR >= $driver->PR1Low and $priceR < $driver->PR2Low) {
                return $price + ($price * $driver->PR1Percent / 100);
            } else {
                if ($priceR >= $driver->PR2Low and $priceR < $driver->PR3Low) {
                    return $price + ($price * $driver->PR2Percent / 100);
                } else {
                    return $price + ($price * $driver->PR3Percent / 100);
                }
            }
        }

        // FIRST CLASS
        if ($VehicleClass >= 21) {
            if ($priceR >= $driver->FR1Low and $priceR < $driver->FR2Low) {
                return $price + ($price * $driver->FR1Percent / 100);
            } else {
                if ($priceR >= $driver->FR2Low and $priceR < $driver->FR3Low) {
                    return $price + ($price * $driver->FR2Percent / 100);
                } else {
                    return $price + ($price * $driver->FR3Percent / 100);
                }
            }
        }
    }

    return '0';
}

function isVehicleOffDuty($vehicleID, $transferDate, $transferTime)
{
    $offDuty = DB::table('v4_OffDuty')
                 ->where('VehicleId', $vehicleID)
                 ->get();

    $cnt = 0;

    foreach ($offDuty as $item) {
        if (inDateTimeRange($item->StartDate, $item->StartTime, $item->EndDate, $item->EndTime, $transferDate, $transferTime)) {

            $cnt += 1;
        }
    }

    return $cnt >= 1;
}


function calculateSpecialDates($OwnerID, $amount, $transferDate, $transferTime, $returnDate = '', $returnTime = '')
{
    $add1 = 0;
    $add2 = 0;

    if (empty($OwnerID) or empty($amount) or empty($transferDate) or empty($transferTime)) {
        return 0;
    }

    $specialDates = SpecialDate::where('OwnerID', $OwnerID)
                               ->orderBy('ID')
                               ->get();

    if ($specialDates->count() > 0) {
        foreach ($specialDates as $specialDate) {
            if (inDateTimeRange($specialDate->SpecialDate, $specialDate->StartTime, $specialDate->SpecialDate, $specialDate->EndTime, $transferDate, $transferTime)) {
                $add1 = nf($amount * $specialDate->CorrectionPercent / 100);
            }

            if ($returnDate != '' and $returnTime != '') {
                if (inDateTimeRange($specialDate->SpecialDate, $specialDate->StartTime, $specialDate->SpecialDate, $specialDate->EndTime, $returnDate, $returnTime)) {
                    $add2 = nf($amount * $specialDate->CorrectionPercent / 100);
                }
            }
        }
    }

    return $add1 + $add2;
}
