<?php

namespace App\Services;

use App\Models\Coupon;

class CouponService
{
    public function check(array $data)
    {
        $bookingDate = date("Y-m-d");
        $transferDate = $data['pickupDate'];
        $returnDate = $data['returnDate'];
        $VehicleTypeID = $data['vehicleType'];
        $FromID = $data['pickupId'];
        $returnTransfer = ['isReturnTransfer']; // 0 ili 1
        $isWeekday = false;
    
        if (getWeekday($transferDate) != 0 and getWeekday($transferDate) != 6) {
            $isWeekday = true;
        }
    
        // ticket $INC-549 - aleksandar
        // oba transfera moraju padati u radni dan.
        // ako je returnTransfer, resetira se $isWeekday i ispituje se na returnDate
        if ($returnTransfer and $isWeekday) {
            $isWeekday = false;
            if (getWeekday($returnDate) != 0 and getWeekday($returnDate) != 6) {
                $isWeekday = true;
            }
        }
        
        $notValid = 0;
    
        $coupon = Coupon::where('Code', trim(strtoupper($data['coupon'])))
                        ->where('Active', 1)
                        ->first();
        
        if (!$coupon) {
            return [
                'value' => 0,
                'description' => __('api.couponNotValid'),
            ];
        }
    
        // vrijeme bookinga
        if ($coupon->ValidFrom != '' and $coupon->ValidTo != '') {
            if (isInDateRange($coupon->ValidFrom, $coupon->ValidTo, $bookingDate) == false) {
                $notValid += 1;
            }
        }
    
        // vrijeme transfera
        if ($coupon->TransferFromDate != '' and $coupon->TransferToDate != '') {
            if (isInDateRange($coupon->TransferFromDate, $coupon->TransferToDate, $transferDate) == false) {
                $notValid += 1;
            }
        }
    
        if ($coupon->WeekdaysOnly == '1' and $isWeekday == false) {
            $notValid += 1;
        }
    
        if ($coupon->LimitLocationID > 0 and $FromID != $coupon->LimitLocationID  ) {
            $notValid += 1;
        }
    
        if ($coupon->ReturnOnly == '1' and $returnTransfer != 1) {
            $notValid += 1;
        }
    
        if ($coupon->VehicleTypeID != '0') {
            if ($this->getVehicleClass($VehicleTypeID) != $coupon->VehicleTypeID) {
                $notValid += 1;
            }
        }
    
        if ($coupon->DriverID && request()->driverId != $coupon->DriverID) {
            $notValid += 1;
        }
    
        // todo: radimo dry apply, kad bude tempToLive, onda update coupon
        if ($notValid == 0) {
            return [
                'value' => $coupon->Discount,
                'description' => __('api.couponApplied'),
            ];
        }
    
        return [
            'value' => 0,
            'description' => __('api.couponNotValid'),
        ];
    }
    
    private function getVehicleClass($VehicleTypeID)
    {
        if ((1 <= $VehicleTypeID) && ($VehicleTypeID <= 100)) {
            return 1;
        }
        
        if ((101 <= $VehicleTypeID) && ($VehicleTypeID <= 200)) {
            return 2;
        }
        
        if ((201 <= $VehicleTypeID) && ($VehicleTypeID <= 300)) {
            return 3;
        }
        
        if ((301 <= $VehicleTypeID) && ($VehicleTypeID <= 400)) {
            return 4;
        }
    }
    
    public function increment($coupon_code)
    {
        $coupon = Coupon::where('Code', trim(strtoupper($coupon_code)))
              ->where('Active', 1)
              ->first();
        
        if (!$coupon) {
            return;
        }
    
        $coupon->TimesUsed++;
    
        $coupon->save();
    }
}