<?php

namespace App\Services;

use Mpdf\Mpdf;
use App\Models\CompanyInfo;
use Mpdf\Output\Destination;

class PdfParser
{
    /**
     * @var Mpdf
     */
    protected $mpdf;

    /**
     * PDF constructor.
     *
     * @param  Mpdf  $mpdf
     */
    public function __construct(Mpdf $mpdf)
    {
        $this->mpdf = $mpdf;
    }

    public function execute($html, $name)
    {
        $this->mpdf->SetDisplayMode('fullpage');

        $this->mpdf->autoScriptToLang = true;

        $this->mpdf->baseScript = 1;

        $stylesheet = '
                @media print {
                    table, tr, td, * {font-size:11px !important; font-family: Arial, sans-serif !important;}
                }
            ';

        $this->mpdf->WriteHTML($stylesheet, 1);    // The parameter 1 tells that this is css/style only and no body/html/text

        $html = $html .'<small style="font-family:Arial, sans-serif;">'. static::pdfFooter(3) . '</small>';

        $this->mpdf->WriteHTML($html);

        $this->mpdf->Output('./pdf/'.$name.'.pdf', Destination::FILE);
    }

    public static function pdfFooter($SiteID)
    {
        $str = '';

        $info = CompanyInfo::find($SiteID);

        if ($info) {
            $str = '<cite><strong>' . $info->co_name . '</strong><br>';
            $str .= $info->co_address . '<br>';
            $str .= $info->co_zip . ' ' . $info->co_city . '<br>';
            $str .= $info->co_country . '<br>';
            $str .= $info->co_tel . '<br>';
            //$str .= $info->co_fax . '<br>';
            $str .= $info->co_email . '</cite>';
        }

        return $str;
    }
}
