<?php

namespace App\Services;

use App\Models\AuthUser;
use App\Models\OrderMaster;
use App\Models\OrderExtras;
use App\Models\OrderDetails;
use App\Models\ExchangeRate;
use App\Models\OrderMasterTemp;
use App\Models\OrderExtrasTemp;
use App\Models\ExchangeRateSRB;
use App\Models\OrderDetailsTemp;

class TempToLive
{
    /**
     * @var string|null
     */
    private $tok;
    
    public function execute($tok = null)
    {
        // IOS Fix
//        if (! session()->has('TOK') || empty(session('TOK')) && isset(request()->MOrderKey) && ! empty(request()->MOrderKey)) {
//            session(['TOK' => request()->MOrderKey]);
//        }
//
//        if (! session()->has('TOK') || empty(session('TOK')) && isset(request()->TOK) && ! empty(request()->TOK)) {
//            session(['TOK' => request()->TOK]);
//        }

//        $UserID = session('UserID');
        $UserID = 53;
        
        $user = AuthUser::find($UserID);

        // affiliate
        if (! empty(request()->header('jamaffid'))) {
            $UserID = request()->header('jamaffid');
            
            $user = AuthUser::find($UserID) ?? $user;
        }
        
        $this->tok = $tok ?? request()->header('tok');

        $orderMasterTemp = OrderMasterTemp::where('MOrderKey', $this->tok)->first();

        if ($orderMasterTemp) {
            $orderMaster = $this->createOrderMaster($orderMasterTemp, $user, $UserID);

            $this->createDetailsAndExtras($orderMaster, $orderMasterTemp, $user, $UserID);

            return $orderMaster;
        }
    }

    /**
     * @param  OrderMasterTemp  $orderMasterTemp
     * @param  AuthUser         $user
     * @param  int              $userId
     *
     * @return mixed
     */
    private function createOrderMaster(OrderMasterTemp $orderMasterTemp, AuthUser $user, int $userId)
    {
        $data = collect($orderMasterTemp->toArray())->except([
            'MOrderKey',
            'MOrderID',
            'MOrderDate',
            'MOrderTime',
            'MUserID',
            'MUserLevelID',
            'MCardNumber',
            'MDriverExtrasPrice',
            'MProvision',
            'ConfirmationSent',
        ]);

        $data->put('MOrderKey', create_order_key());
        $data->put('MOrderDate', date("Y-m-d"));
        $data->put('MOrderTime', date("H:i:s"));
        $data->put('MUserID', $userId);
        $data->put('MUserLevelID', $user->AuthLevelID);
        $data->put('MCardNumber', $this->tok);
        $data->put('MDriverExtrasPrice', 0);
        $data->put('MProvision', 0);

        $exchangeRate = null;

        if ($orderMasterTemp->MPaymentMethod == 1 || $orderMasterTemp->MPaymentMethod == 3) {
            $exchangeRate = ExchangeRate::where('Name', 'EUR')->first();
        }

        if ($orderMasterTemp->MPaymentMethod == 2 || $orderMasterTemp->MPaymentMethod == 4) {
            $exchangeRate = ExchangeRateSRB::where('Name', 'EUR')->first();
        }

        if ($exchangeRate) {
            $data->put('MEurToCurrencyRate', $exchangeRate->Average);
        }

        return OrderMaster::create($data->toArray());
    }

    /**
     * @param  OrderMaster      $orderMaster
     * @param  OrderMasterTemp  $orderMasterTemp
     * @param  int              $UserID
     * @param  AuthUser         $user
     */
    private function createDetailsAndExtras(OrderMaster $orderMaster, OrderMasterTemp $orderMasterTemp, AuthUser $user, int $UserID)
    {
        $orderDetailsTemp = OrderDetailsTemp::where('OrderID', $orderMasterTemp->MOrderID)->get();

        foreach ($orderDetailsTemp as $detail) {
            // postavi status na not confirmed ako je dodijeljen driver
            $driverConfStatus = $detail->DriverID > 0 ? 1 : 0;

            // payment status - todo: mislim da ne treba ovo...
            if ($detail->PayLater == 0) {
                $paymentStatus = 99;// placeno u cijelosti
            }

            $orderDetailsTempArray = collect($detail->toArray())->except([
                'OrderID',
                'UserLevelID',
                'DriverExtraCharge',
                'Provision',
                'PaymentMethod',
                'PaymentStatus',
                'DetailsID',
                'DriverConfStatus',
            ]);

            $orderDetailsTempArray->put('OrderID', $orderMaster->MOrderID);
            $orderDetailsTempArray->put('UserID', $UserID);
            $orderDetailsTempArray->put('UserLevelID', $user->AuthLevelID);
            $orderDetailsTempArray->put('OrderDate', date("Y-m-d"));
            $orderDetailsTempArray->put('PaxName', $orderMasterTemp->MPaxFirstName . ' ' . $orderMasterTemp->MPaxLastName);
            $orderDetailsTempArray->put('PaymentMethod', $orderMasterTemp->MPaymentMethod);
            $orderDetailsTempArray->put('PaymentStatus', $orderMasterTemp->MPaymentStatus);
            $orderDetailsTempArray->put('DriverConfStatus', $driverConfStatus);
            
            // todo: handle-uj ovo nekako...
            if (session()->has('DriverExtraCharge') && session()->has('DriverExtraCharge')) {
                $orderDetailsTempArray->put('DriverExtraCharge', $detail->TNo == 1 ? session('DriverExtraCharge') : session('XDriverExtraCharge'));
                $orderDetailsTempArray->put('DriverPaymentAmt', ($detail->TNo == 1 ? session('DriverExtraCharge') : session('XDriverExtraCharge')) + $detail->DriversPrice);
            }

            $orderDetails = OrderDetails::create($orderDetailsTempArray->toArray());

            self::createExtras($detail->DetailsID, $orderDetails->DetailsID);
        }
    }

    /**
     * @param  int  $orderDetailsTempId
     * @param  int  $orderDetailsId
     */
    private static function createExtras(int $orderDetailsTempId, int $orderDetailsId)
    {
        $orderExtrasTemp = OrderExtrasTemp::where('OrderDetailsId', $orderDetailsTempId)->get();

        foreach ($orderExtrasTemp as $extra) {
            $data = collect($extra->toArray())->except('ID', 'OrderDetailsID')
                                              ->put('OrderDetailsID', $orderDetailsId)
                                              ->toArray();

            OrderExtras::create($data);
        }
    }
}
