<?php

use App\Models\Place;
use App\Models\Service;
use App\Models\Country;
use App\Models\AuthUser;
use App\Models\VehicleType;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon;

if (! function_exists('Lang')) {
    function Lang()
    {
        //return Str::upper(app()->getLocale());
        return "EN";
    }
}

if (! function_exists('isInDateRange')) {
    function isInDateRange($start, $end, $needle)
    {
        if (empty($start)) {
            return false;
        }
        if (empty($end)) {
            return false;
        }
        if (empty($needle)) {
            return false;
        }

        $fullStart = $start;
        $fullEnd = $end;

        if ($fullStart < $fullEnd) {
            return ($needle >= $fullStart) && ($needle <= $fullEnd);
        }
        if ($fullStart > $fullEnd) {
            $fullEnd = date("Y") + 1 . '-' . $end;
            return ($needle >= $fullStart) && ($needle <= $fullEnd);
        }
        if ($fullStart == $fullEnd) {
            return ($needle == $fullStart) && ($needle == $fullEnd);
        }
    }
}

if (! function_exists('getWeekday')) {
    function getWeekday($date)
    {
        return date('w', strtotime($date));
    }
}

if (! function_exists('getPlaceName')) {
    function getPlaceName($placeID)
    {
        return Place::where('PlaceID', $placeID)->first()->{'PlaceName' . Lang()};
    }
}

if (! function_exists('getPlaceSEO')) {
    function getPlaceSEO($placeID)
    {
        return Place::where('PlaceID', $placeID)->first()->{'PlaceNameSEO'};
    }
}

if (! function_exists('pickupPossible')) {
    function pickupPossible($PickupDate, $PickupTime, $authUser)
    {
        $dt = explode('-', $PickupDate);
        $tm = explode(':', $PickupTime);
        $restHours = (mktime($tm[0], $tm[1], 0, $dt[1], $dt[2], $dt[0]) - time()) / 3600;

         if (($authUser->Temp_pass_active > 0 ? $authUser->Temp_pass_active : 14) > $restHours) {
            return false;
        }

         return true;


        //        $wantedTime = strtotime($PickupDate . ' ' . $PickupTime . ':00'); // sto putnik zeli
        //        $allowedTime = time() + (14 * 3600); // 13 sati od sada + razlika od GMT koja je 1 sat za nas

                // zaustavi booking ako je manje
        //        if ($wantedTime > $allowedTime) {
        //            return true;
        //        } else {
        //            return false;
        //        }
    }
}

if (! function_exists('getMaxPax')) {
    function getMaxPax($vehicleTypeId)
    {
        return VehicleType::where('VehicleTypeID', $vehicleTypeId)->first()->Max;
    }
}

if (! function_exists('getVehicleTypeName')) {
    function getVehicleTypeName($vehicleTypeId)
    {
        return VehicleType::where('VehicleTypeID', $vehicleTypeId)->first()->{'VehicleTypeName' . Lang()};
    }
}

if (! function_exists("getVehicleMaxPax")) {
    function getVehicleMaxPax($vehicleTypeID) {
        return VehicleType::where('VehicleTypeID', $vehicleTypeID)->first()->{'Max'};
    }
}

if (! function_exists('Eur2')) {
    function Eur2($iznos, $currency)
    {
        if ($currency == '' or $currency == 'EUR') {
            return nf($iznos);
        }
    }
}
if (! function_exists('nf')) {
    function nf($number)
    {
        return number_format($number, 2, '.', '');
    }
}

if (! function_exists('create_order_key')) {
    # kreira random broj narudzbe
    function create_order_key()
    {
        srand(time());
        $whichone1 = (rand() % 10);
        $whichone2 = (rand() % 10);
        $whichone3 = (rand() % 10);
        $whichone4 = (rand() % 10);
        $whichone5 = (rand() % 10);
        $str = "";
        $str2 = "ABCDEFGHIJKLMNPQRSTUVWXYZ";
        for ($i = 0; $i < 10; $i++) {
            $random = (rand() % 10);
            $random2 = (rand() % 11);
            $random3 = (rand() % 25);
            if ($i == $whichone1 || $i == $whichone2 || $i == $whichone3 || $i == $whichone4 || $i == $whichone5) {
                $str .= $str2[$random3];
            } else {
                if ($random == 0) {
                    $random = 1;
                }
                $str .= $random;
            }
        }

        return $str;
    }
}

// Dodavanje dogovorene provizije na osnovnu cijenu
if (! function_exists('addJTProvision')) {
    function addJTProvision($price, $ownerid, $VehicleClass = 1)
    {
        // ako je u decimalama, zaokruzi na cijeli broj
        // npr. 299.20 treba zaokruziti na 299 radi toga sto su usporedne cijene na cijeli broj
        // 100-299, pa onda 300-9999
        // pa ako se ide usporediti onda je 299.20 vece od 299, ali je i manje od 300
        // i onda nece upasti ni u jedan if
        $priceR = round($price, 0, PHP_ROUND_HALF_DOWN);

        $driver = AuthUser::find($ownerid);

        if ($driver->AuthUserID == $ownerid) {

            // STANDARD CLASS
            if ($VehicleClass < 11) {
                if ($priceR >= $driver->R1Low and $priceR <= $driver->R1Hi) {
                    return $price + ($price * $driver->R1Percent / 100);
                } else {
                    if ($priceR >= $driver->R2Low and $priceR <= $driver->R2Hi) {
                        return $price + ($price * $driver->R2Percent / 100);
                    } else {
                        if ($priceR >= $driver->R3Low and $priceR <= $driver->R3Hi) {
                            return $price + ($price * $driver->R3Percent / 100);
                        } else {
                            return $price;
                        }
                    }
                }
            }

            // PREMIUM CLASS
            if ($VehicleClass >= 11 and $VehicleClass < 21) {
                if ($priceR >= $driver->PR1Low and $priceR <= $driver->PR1Hi) {
                    return $price + ($price * $driver->PR1Percent / 100);
                } else {
                    if ($priceR >= $driver->PR2Low and $priceR <= $driver->PR2Hi) {
                        return $price + ($price * $driver->PR2Percent / 100);
                    } else {
                        if ($priceR >= $driver->PR3Low and $priceR <= $driver->PR3Hi) {
                            return $price + ($price * $driver->PR3Percent / 100);
                        } else {
                            return $price;
                        }
                    }
                }
            }

            // FIRST CLASS
            if ($VehicleClass >= 21) {
                if ($priceR >= $driver->FR1Low and $priceR <= $driver->FR1Hi) {
                    return $price + ($price * $driver->FR1Percent / 100);
                } else {
                    if ($priceR >= $driver->FR2Low and $priceR <= $driver->FR2Hi) {
                        return $price + ($price * $driver->FR2Percent / 100);
                    } else {
                        if ($priceR >= $driver->FR3Low and $priceR <= $driver->FR3Hi) {
                            return $price + ($price * $driver->FR3Percent / 100);
                        } else {
                            return $price;
                        }
                    }
                }
            }

        }

        return '0';
    }
}

if (! function_exists('getDriverPrice')) {
    function getDriverPrice($ServiceID)
    {
        return Service::find($ServiceID)->ServicePrice1;
    }
}

if (! function_exists('toCurrency')) {
    function toCurrency($iznos)
    {
        if (! isset($_SESSION['Currency']) or $_SESSION['Currency'] == '') {
            return $iznos;
        }

        $tecajevi = ParseTecaj();
        $EUR = $tecajevi['EUR']['avg'];
        $tecajValute = $tecajevi[$_SESSION['Currency']]['avg'];
        $zaJedan = $tecajValute / $tecajevi[$_SESSION['Currency']]['for'];

        if ($zaJedan == '0') {
            return nf($iznos);
        }

        return nf($iznos * ($EUR / $zaJedan));
    }
}

if (! function_exists('getPlaceType')) {
    function getPlaceType($placeID)
    {
        return Place::find($placeID)->PlaceType;
    }
}

if (! function_exists('dateToLang')) {
    function dateToLang($date, $lang = 'EN')
    {

        $lang = Lang();
        $dayName = date("l", strtotime($date));
        $monthName = date("F", strtotime($date));
        $dayNumber = date("d", strtotime($date));
        $year = date("Y", strtotime($date));

        $daysEN = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
        $daysFR = ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'];
        $daysRU = ['понедельник', 'вторник', 'среда', 'четверг', 'пятница', 'суббота', 'воскресенье'];
        $daysDE = ["Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag", "Sonntag"];

        $monthEN = [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December',
        ];

        $monthFR = [
            'Janvier',
            'Février',
            'Mars',
            'Avril',
            'Mai',
            'Juin',
            'Juillet',
            'Août',
            'Septembre',
            'Octobre',
            'Novembre',
            'Décembre',
        ];

        $monthRU = [
            'Январь',
            'Февраль',
            'Март',
            'Апрель',
            'Май',
            'Июнь',
            'Июль',
            'Август',
            'Сентябрь',
            'Октябрь',
            'Ноябрь',
            'Декабрь',
        ];

        $monthDE = [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember',
        ];

        $dayKey = array_search($dayName, $daysEN);
        $monthKey = array_search($monthName, $monthEN);

        switch ($lang) {
            case 'EN':
                return $daysEN[$dayKey] . ', ' . $monthEN[$monthKey] . ' ' . $dayNumber . ' ' . $year;
            case 'DE':
                return $daysDE[$dayKey] . ', ' . $monthDE[$monthKey] . ' ' . $dayNumber . ' ' . $year;
            case 'RU':
                return $daysRU[$dayKey] . ', ' . $dayNumber . ' ' . $monthRU[$monthKey] . ' ' . $year;
            case 'FR':
                return $daysFR[$dayKey] . ', ' . $dayNumber . ' ' . $monthFR[$monthKey] . ' ' . $year;
        }

    }
}

if (! function_exists('acceptedPayment')) {
    // koje nacine placanja vozac prihvaca
    function acceptedPayment($DriverID)
    {

        $driver = AuthUser::find($DriverID);

        return $driver->AuthUserID == $DriverID
            ? $driver->AcceptedPayment
            : 0; // ako nije naslo drivera, pretpostavka je da se prima bilo koji nacin placanja
    }
}

if (! function_exists('getPlaceCountryCode')) {
    function getPlaceCountryCode($countryID)
    {
        return Country::find($countryID)->CountryCode ?? '';
    }
}

if (! function_exists('getPlaceIDFromPlaceName')) {
    function getPlaceIDFromPlaceName($placeName)
    {
        $place = Place::where('PlaceNameSEO', 'like', $placeName)
                      ->orWhere('PlaceNameEN', 'like', $placeName)
                      ->orWhere('PlaceNameRU', 'like', $placeName)
                      ->orWhere('PlaceNameDE', 'like', $placeName)
                      ->orWhere('PlaceNameFR', 'like', $placeName)
                      ->orWhere('PlaceNameIT', 'like', $placeName)
                      ->first();

        if ($place) {
            return $place->PlaceID;
        }
    }
}

if (! function_exists('getPlaceCountryFromPlaceName')) {
    function getPlaceCountryFromPlaceName($placeName)
    {
        $place = Place::where(function ($query) use ($placeName) {
            $query->where('PlaceNameSEO', $placeName)
                  ->orWhere('PlaceNameEN', $placeName)
                  ->orWhere('PlaceNameRU', $placeName)
                  ->orWhere('PlaceNameDE', $placeName)
                  ->orWhere('PlaceNameFR', $placeName)
                  ->orWhere('PlaceNameIT', $placeName);
        })
                      ->first();
        if ($place) {
            return $place->PlaceCountry;
        }
    }
}


if (!function_exists('getPaymentMethod')) {
    function getPaymentMethod($paymentMethod)
    {
        switch ($paymentMethod) {
            case 0:
                return 'Undefined';
                break;
            case 1:
                return 'Online';
                break;
            case 2:
                return 'Cash';
                break;
            case 3:
                return 'Online cash';
                break;
            case 4:
                return 'invoice';
                break;
            case 5:
                return 'Compensation';
                break;
            case 9:
                return 'Other';
                break;
        }
    }
}

if (!function_exists('isLocalAgent')) {
    // CMS: Agent Booking Form
    // provjerava jeli $AuthUserID od agenta jedan od dozvoljenih
    // (napravit transfer na isti dan, cash placanje)
    function isLocalAgent($agentID)
    {
        $local = 0;
        $allowed = [234, 406, 409, 422, 789, 919]; // dozvoljeni agenti

        for ($i = 0; $i < count($allowed); $i++) {
            if ($agentID == $allowed[$i]) {
                $local = 1;
            }
        }

        return $local;
    }
}
