<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Models\LanguageLine;
use App\Imports\TranslationsImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Api\EmailQuoteController;

Route::get('/import-translations', function () {
    LanguageLine::truncate();
    
    Excel::import(new TranslationsImport, storage_path('translations.xlsx'));
    
    return 'Translations imported successfully...';
});

Route::get('send/emailQuote/tempToLive', [EmailQuoteController::class, 'tempToLive'])->name('tempToLive');
Route::get('/greeting', function () {
    return 'Hello World';
});
