<?php

namespace App\Http\Controllers\Api;

use App\Services\PrintVoucher;
use App\Models\AuthUser;
use App\Services\PdfParser;
use App\Models\OrderMaster;
use App\Mail\OrderConfirmed;
use App\Mail\DriverConfirmation;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class ConfirmOrderController extends Controller
{
    public function index($OrderID = null, PdfParser $pdfParser)
    {
        if (request()->isMethod('get')) {
            if(!isset($OrderID) and !is_numeric($OrderID)) {
                if (!request()->query('id')) {
                    return response()->json([
                        'message' => 'Order does not exist.'
                    ]);
                }
            };
        }
        
        $OrderID = $OrderID  ?? request()->query('id');
        
        if (request()->isMethod('post')) {
            $OrderID = request()->id;
        }
        
        $orderMaster = OrderMaster::find($OrderID);
        
        if($orderMaster->MOrderID != $OrderID or $orderMaster->MOrderStatus == '9') {
            return response()->json([
                'message' => 'No such order.'
            ]);
        }
        
        if($orderMaster->MOrderID != $OrderID or $orderMaster->MOrderStatus == '3') {
            return response()->json([
                'message' => 'Order is canceled.'
            ]); //Transfer je kanselovan u administraciji, ne moze se ponovo aktivirati
        }
        
        if($orderMaster->MOrderID == '' or $orderMaster->MOrderID != $OrderID) {
            return response()->json([
                'message' => '<h2>'.request()->id.' - this Order does not exist in our system.</h2>'
            ]);
        }
        
        $OrderKey = $orderMaster->MOrderKey . '-' . $orderMaster->MOrderID;
        
        // Temp Order Status = 4 !
        if (!isset(request()->confirm) and !isset(request()->cancel) and $orderMaster->MOrderStatus == 4) {
            $voucher = PrintVoucher::execute($orderMaster->MOrderID);
            
            return response()->json([
                'voucher' => $voucher,
                'first_name' => $orderMaster['MPaxFirstName'],
                'last_name' => $orderMaster['MPaxLastName'],
            ]);
        }
        else if (request()->cancel == 'cancel' and $orderMaster->MOrderStatus == '4') {
            $orderMaster->MOrderStatus = 3;
            $orderMaster->save();

            $orderMaster->details()->update(['TransferStatus' => 3]);
            
            return response()->json([
                'text' => 'Your Order is cancelled.<br>You can close this window now.'
            ]);
        }
        else if (request()->confirm == 'confirm'  and $orderMaster->MOrderStatus == '4') {
            // confirmed
            
            $orderMaster->MOrderStatus = 2;
            $orderMaster->save();

            $orderMaster->details()->update(['TransferStatus' => 1]);
            
            $voucher = PrintVoucher::execute($orderMaster->MOrderID);
            
            $pdfParser->execute($voucher, $OrderKey);

            $this->sendEmails($orderMaster, $voucher);
    
            return response()->json([
                'text' => 'Thank You!<br>Your Order is now Confirmed.<br>You will receive our Confirmation e-mail in a few minutes.',
                'voucher' => $voucher,
                // for google conversion
                'user_id' => $orderMaster->MUserID,
            ]);
        }
        else {
            $text = '';
            
            if ($orderMaster->MOrderStatus === 2) {
                $text = 'Your have already confirmed your order:';
            }
            
            if ($orderMaster->MOrderStatus === 3) {
                $text = 'Your have already cancelled your order:';
            }
            
            $text .= '<br>' . $OrderKey;
            
            $text .= '<br>' . ucfirst($orderMaster->MPaxFirstName) . ' ' . ucfirst($orderMaster->MPaxLastName);
            
            $text .= '<br> Thank You!';
            
            return response()->json([
                'name' => ucfirst($orderMaster->MPaxFirstName) . ' ' . ucfirst($orderMaster->MPaxLastName),
                'orderKey' => $OrderKey,
                'message' => $text
            ]);
        }
    }
    
    /**
     * @param $orderMaster
     * @param $voucher
     */
    private function sendEmails($orderMaster, $voucher): void
    {
        Mail::to([
            $orderMaster->MPaxEmail,
            'cms@jamtransfer.com'
        ])
            ->send(new OrderConfirmed($orderMaster, $voucher));
        
        Mail::to([
            $orderMaster->details->last()->DriverEmail,
            'cms@jamtransfer.com'
        ])
            ->send(new DriverConfirmation($orderMaster));
    }
}
