<?php

namespace App\Http\Controllers\Api;

use App\Mail\EmailQuote;
use App\Mail\ContactEmail;
use App\Services\CarsService;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class ContactController extends Controller
{
    public function index()
    {
        $validator = Validator::make(request()->all(), [
            'name'    => 'required',
            'email'   => 'required',
            'message' => 'required',
        ]);
    
        if ($validator->fails()) {
            return response()->json(['message' => __('api.validationFailed')], 422);
        }
    
        Mail::to(config('mail.from.address'))
            ->send(new ContactEmail(request()->all()));
    
        return response()->json([
            'message' => __('api.contactMailReceivedText')
        ]);
    }
}
