<?php

namespace App\Http\Controllers\Api;

use App\Models\Route;
use App\Models\TopRoute;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Services\SearchPlaceService;
use Illuminate\Support\Facades\DB;

class PlacesSearchController extends Controller
{
    /**
     * @var SearchPlaceService
     */
    private $searchPlaceService;
    
    public function __construct(SearchPlaceService $searchPlaceService)
    {
        $this->searchPlaceService = $searchPlaceService;
    }
    
    /**
     * @return JsonResponse
     */
    public function searchPlace(): JsonResponse
    {
        if (request()->fID) {
            $places = $this->searchPlaceService->searchDropoff(request()->fID, $this->parseQuery());
        } else {
            $places = $this->searchPlaceService->searchPickup($this->parseQuery());
        }
    
        return response()->json($places);
    }
    
    public function find()
    {
         $place = $this->searchPlaceService->findPlaceFromPlaceName(request()->name);
         
         if (!$place) {
             return response()->json([
                 'message' => 'Not found'
             ], 422);
         }
         $tid = $place['id'];
         $terminalImage = "";
         $timg = "";
         $terminal = DB::select("select * from v4_Terminals where TerminalID = $tid");
         if ($terminal) {
         $terminal = $terminal[0];
         $timg = $terminal->ImageBG;
         
         $terminalImage = $timg;
             
         }
         
         if ($timg == "") {
             $terminalImage = "/i/website/home.webp";
         }
         $place2 = [
                "id"=>$place["id"],
                "name" => $place['name'],
                "image"=> "https://wis.jamtransfer.com$terminalImage"
             ]; 
      //   echo($place["id"]);
      
      $place = $place2;
        return response()->json([
            'place' => $place
        ]);
    }
    
    /**
     * @return JsonResponse
     */
    public function destinations(): JsonResponse
    {
        if (! request()->id || ! request()->type) {
            return response()->json([], 422);
        }
        
        $destinations = $this->searchPlaceService->getDestinations(request()->type, request()->id);
        
        return response()->json($destinations);
    }
    
    /**
     * @return JsonResponse
     */
    public function description(): JsonResponse
    {
        if (! request()->fromId || ! request()->toId) {
            return response()->json([], 422);
        }
        
        $topRoute = TopRoute::whereHas('route', function ($query) {
                                $query->where('FromID', request()->fromId)->where('ToID', request()->toId);
                            })
                            ->first();
        
        return response()->json([
            'description' => optional($topRoute)->Description[strtolower(Lang())]
        ]);
    }

    /**
     * @return string
     */
    private function parseQuery(): string
    {
        return explode(',', trim(request()->qry))[0];
    }
}
