<?php

namespace App\Http\Controllers\Api;

use DateTime;
use DateInterval;
use App\Models\Extra;
use App\Models\ExtraMaster;
use App\Services\CarsService;
use App\Services\WebpayService;
use Illuminate\Support\Collection;
use App\Http\Controllers\Controller;
use App\Services\BookingDataService;
use App\Http\Resources\CarsResource;
use App\Http\Resources\TransferResource;
use App\Http\Resources\DriverExtrasResource;
use Illuminate\Support\Facades\Log;

class TransfersController extends Controller
{
    public function index()
    {
        $transfer = BookingDataService::get();

        $cars = $this->getCars($transfer);


        return response()->json(compact('cars'));
    }
    
    public function transfer()
    {
        $transfer = BookingDataService::get();
        
        return response()->json([
            'transfer' => $transfer ? new TransferResource($transfer) : null
        ]);
    }
    
    /**
     * @param $transfer
     *
     * @return Collection
     */
    private function getCars($transfer): Collection
    {
        return collect(CarsService::get($transfer))
            ->map(function ($car) use ($transfer) {

                if ($car['FinalPrice'] > 0) {

                    $detailsDesc = '';
                    if ($car['Km'] > 0) {
                        $detailsDesc .= $car['Km'] . ' km, ';
                    }
            
                    if ($car['Duration'] > 0) {
                        $detailsDesc .= $car['Duration'] . ' mins';
                    }
            
                    if ($detailsDesc != '') {
                        $detailsDesc = '<span class="grey-text light">
                        <i class="fa fa-clock-o"></i> ~' . $detailsDesc . '</span>';
                    }
            
                    $addToPrice = $car['MonPrice'] +
                        $car['TuePrice'] +
                        $car['WedPrice'] +
                        $car['ThuPrice'] +
                        $car['FriPrice'] +
                        $car['SatPrice'] +
                        $car['SunPrice'] +
                        $car['S1Price'] +
                        $car['S2Price'] +
                        $car['S3Price'] +
                        $car['S4Price'] +
                        $car['S5Price'] +
                        $car['S6Price'] +
                        $car['S7Price'] +
                        $car['S8Price'] +
                        $car['S9Price'] +
                        $car['S10Price'];
            
                    // ovo je sve dodano u getCars i spremljeno u FinalPrice
                    $displayPrice = $car['FinalPrice'];
                    // normalna cijena bez addToPrice!!!
                    // dakle ono sto je u cjeniku
            
            
                    $fullPrice = addJTProvision(
                        getDriverPrice($car['ServiceID']),
                        $car['OwnerID'],
                        $car['VehicleClass']
            
                    );
            
                    if (count($transfer) > 2) {
                        $fullPrice = $fullPrice * 2;
                    }
                    // zaokruzenje cijena
                    //$fullPrice= number_format( round($fullPrice,0,PHP_ROUND_HALF_UP) );
                    $fullPrice = nf(round($fullPrice, 2), 2);
            
                    $car['StartingPrice'] = $fullPrice;

                    $car['extras'] = $this->getExtras($car['OwnerID']);
                    
                    $vehicleNumber = ceil(($car['PaxNo'] / $car['VehicleCapacity']));
                    //$vehicleNumber = $car['PaxNo'];
                   // $maxPax = ceil(1.2);
                    $car['vehicleNo'] = $vehicleNumber;


                     return new CarsResource($car);
                }
            });
    }
    
    public function getTransferDetailsForm()
    {
        $transfer = BookingDataService::get();
        
        $returnTransfer = count($transfer) > 2 ? 1 : 0;
        
        $pickupType = getPlaceType($transfer[0]['PickupID']);
        $dropType = getPlaceType($transfer[0]['DropID']);
    
        $minutes_to_add = request()->Duration + 15;
        $time = new DateTime($transfer[0]['PickupDate'].' '.$transfer[0]['PickupTime']);
        $time->add(new DateInterval('PT'.$minutes_to_add.'M'));
        $expectedArrival = $time->format('H:i');
        
        if ($returnTransfer) {
            $RpickupType = getPlaceType($transfer[1]['PickupID']);
            $RdropType = getPlaceType($transfer[1]['DropID']);
    
            $time = new DateTime($transfer[1]['PickupDate'].' '.$transfer[1]['PickupTime']);
            $time->add(new DateInterval('PT'.$minutes_to_add.'M'));
            $returnExpectedArrival = $time->format('H:i');
        }
    
        $duration = request()->Duration;
    
        $maxPax = getMaxPax($transfer[0]['VehicleType']) * $transfer[0]['VehiclesNo'];
        
        $isPickupAirport = false;
        $isDropAirport = false;
        $isReturnPickupAirport = false;
        $isReturnDropAirport = false;
        
        if ($pickupType == '1') {
            $isPickupAirport = true;
            $pickupFlightText = __('api.arrivalFlightNumber');
            $pickupFlightTime = __('api.arrivalFlightTime');
        }
        if ($dropType == '1') {
            $isDropAirport = true;
            $dropFlightText = __('api.departureFlightNumber');
            $dropFlightTime = __('api.departureFlightTime');
        }
        if ($RpickupType == '1') {
            $isReturnPickupAirport = true;
            $returnPickupText = __('api.arrivalFlightNumber');
            $returnPickupTime = __('api.arrivalFlightTime');
        }
        if ($RdropType == '1') {
            $isReturnDropAirport = true;
            $returnDropText = __('api.departureFlightNumber');
            $returnDropTime = __('api.departureFlightTime');
        }
        
        return response()->json([
            compact(
                'duration',
                'expectedArrival',
                'returnExpectedArrival',
                'maxPax',
                'isPickupAirport',
                'isReturnPickupAirport',
                'isDropAirport',
                'isReturnDropAirport',
                'pickupFlightText',
                'pickupFlightTime',
                'dropFlightText',
                'dropFlightTime',
                'returnPickupText',
                'returnPickupTime',
                'returnDropText',
                'returnDropTime'
            )
        ]);
    }
    
    public function getPaymentInfo(WebpayService $service)
    {
        $transfer = BookingDataService::get();
        
        [$FullPayment, $TPayNow, $TPayLater, $TXPayNow, $TXPayLater] = $service->calculate($transfer);
        
        return response()->json([
            'payment_method' => acceptedPayment($transfer[0]['DriverID']),
            'outbound_pay_now' => nf($TPayNow),
            'return_pay_now' => nf($TXPayNow),
            'pay_now' => nf($TPayNow + $TXPayNow),
            'outbound_pay_later' => nf($TPayLater),
            'return_pay_later' => nf($TXPayLater),
            'pay_later' => nf($TPayLater + $TXPayLater),
            'total' => $FullPayment,
        ]);
    }
    
    private function getExtras($OwnerID)
    {
        $extras = Extra::where('OwnerID', $OwnerID)->get();
    
        $items = [];
    
        if ($extras->count() > 0) {
            foreach ($extras as $extra) {
                $items[] = array_merge(
                    $extra->toArray(),
                    ['order' => ExtraMaster::where('ID', $extra->ServiceID)->first()->DisplayOrder]
                );
            }
        
            usort($items, function ($first, $second) {
                return $first['order'] > $second['order'];
            });
        }
    
        return collect($items)->map(function ($item) {
            return new DriverExtrasResource($item);
        });
    }
}
