<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class DetectLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param string ...$locales
     * @return mixed
     */
    public function handle(Request $request, Closure $next, string ...$locales)
    {
        $language = $request->getPreferredLanguage($locales);
        app()->setLocale($language);

        $response = $next($request);
        $response->header('Content-Language', $language);

        return $response;
    }
}
