<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\OrderMasterTemp;

class setTOK
{
    /**
     * @var string
     */
    private $tok;
    
    public function __construct()
    {
        $this->tok = time().rand(10000,99999);
    }
    
    /**
     * Handle an incoming request.
     *
     * @param  Request  $request
     * @param  \Closure $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // If request is for routes that doesn't require tok, just return response.
        if ($request->route()->getName() === 'get.translations') {
            return $next($request);
        }
        
        $tok = $request->header('tok');
        
        // If cookie does not exist in the request e.g. user visiting website for the first time.
        if (!$tok) {
            // We are coming from controller.
            $response = $next($request);
            
            // Setting newly generated tok to header.
            $response->header('tok', $this->tok);
            
            // There is no point to going further, so we are returning the response.
            return $response;
        }
    
        // Here, we will change tok only if request is coming from specific url and if OrderMasterTemp exists.
        // We are doing this because for online payments, tok must be unique.
        // Use case, when the user choose online payment, but afterwards he chooses online + cash.
        if ($request->route()->getName() === 'get.monri.credentials' && $orderMasterTemp = OrderMasterTemp::where('MOrderKey', $tok)->first()) {
            // Generating new tok
            $tok = $this->tok;
        
            // and setting to MOrderKey.
            $orderMasterTemp->MOrderKey = $tok;
            $orderMasterTemp->save();
            
            // Here we need to set tok on the request,
            // because when entering controller, we want newly generated key.
            // That key is used to find OrderMasterTemp and making order for online payments.
            $request->headers->set('tok', $tok);
        }
        
        // Everything above is before entering controller.
        $response = $next($request);
        // Everything below is after exiting controller
        
        // Finally, setting tok to header
        $response->header('tok', $tok);

        // and forward the response.
        return $response;
    }
}
