<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CarsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this['VehicleID'],
            'name' => $this['VehicleName'],
            'duration' => $this['Duration'],
            'capacity' => $this['VehicleCapacity'],
            'starting_price' => $this['StartingPrice'],
            'final_price' => floatval($this['FinalPrice']),
            'description' => $this['VehicleDescription'],
            'image' => $this['VehicleImage'],
            'driver_price' => $this['DriversPrice'],
            'one_way_price' => $this['OneWayPrice'],
            'route_id' => $this['RouteID'],
            'service_id' => $this['ServiceID'],
            'driver_id' => $this['OwnerID'],
            'driver_name' => $this['DriverCompany'],
            'vehicle_id' => $this['VehicleID'],
            'vehicle_type_id' => $this['VehicleTypeID'],
            'vehicle_class' => $this['VehicleClass'],
            'extras' => $this['extras'],
            'wifi' => $this['WiFi'],
            'vehicleNo' => $this['vehicleNo']
        ];
    }
}
