<?php

namespace App\Http\Resources;

use Illuminate\Support\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class TransferResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $isReturnTransfer = count($this->resource) === 3;
        return [
            'is_return_transfer'     => $isReturnTransfer,
            'order_type'             => $this['Master']['MOrderType'],
            'site_id'                => $this['Master']['SiteID'],
            'user_id'                => $this['Master']['MUserID'],
            'user_level_id'          => $this['Master']['MUserLevelID'],
            'order_key'              => $this['Master']['MOrderKey'],
            'tok'                    => $this['Master']['MOrderKey'],
            'm_order_date'           => $this['Master']['MOrderDate'],
            'm_order_time'           => $this['Master']['MOrderTime'],
            'order_status'           => $this['Master']['MOrderStatus'],
            'transfer_price'         => $this['Master']['MTransferPrice'],
            'extras_price'           => $this['Master']['MExtrasPrice'],
            'order_price_eur'        => $this['Master']['MOrderPriceEUR'],
            'eur_to_currency_rate'   => $this['Master']['MEurToCurrencyRate'],
            'order_currency_price'   => $this['Master']['MOrderCurrencyPrice'],
            'order_currency'         => $this['Master']['MOrderCurrency'],
            'pay_now'                => $this['Master']['MPayNow'],
            'pay_later'              => $this['Master']['MPayLater'],
            'vehicles'               => $this[0]['VehiclesNo'],
            'return_vehicles'        => $this[1]['VehiclesNo'],
            'order_date'             => $this['Master']['MOrderDate'],
            'return_order_date'      => $this['Master']['MOrderDate'],
            'coupon_discount'        => $this['Master']['Discount'],
            'discount'               => $this['Master']['Discount'],
            'return_discount'        => $this['Master']['Discount'],
            'transfer_status'        => $this[0]['TransferStatus'],
            'return_transfer_status' => $this[0]['TransferStatus'],
            'pickup'                 => ['name' => $this[0]['PickupName'], 'id' => $this[0]['PickupID'], 'type' => getPlaceType($this[0]['PickupID'])],
            'drop'                   => ['name' => $this[0]['DropName'], 'id' => $this[0]['DropID'], 'type' => getPlaceType($this[0]['DropID'])],
            'date_time'              => (new Carbon($this[0]['PickupDate'] . ' ' . $this[0]['PickupTime']))->toDateTimeString(),
            'return_pickup'          => $isReturnTransfer ? ['name' => $this[1]['PickupName'], 'id' => $this[1]['PickupID']] : '',
            'return_drop'            => $isReturnTransfer ? ['name' => $this[1]['DropName'], 'id' => $this[1]['DropID']] : '',
            'return_date_time'       => $isReturnTransfer ? (new Carbon($this[1]['PickupDate'] . ' ' . $this[1]['PickupTime']))->toDateTimeString() : '',
            'passengers'             => $this[0]['PaxNo'],
            'details_id'             => $this[0]['DetailsID'],
            'return_details_id'      => $isReturnTransfer ? $this[1]['DetailsID'] : '',
            'extra_charge'           => $this[0]['ExtraCharge'],
            'return_extra_charge'    => $isReturnTransfer ? $this[1]['ExtraCharge'] : '',
            'driver_extra_charge'    => 0, // temp
            'return_driver_extra_charge'    => 0, // temp
            'first_name'             => $this['Master']['MPaxFirstName'],
            'last_name'              => $this['Master']['MPaxLastName'],
            'email'                  => $this['Master']['MPaxEmail'],
            'phone'                  => $this['Master']['MPaxTel'],
        ];
    }
}
