<?php

namespace App\Imports;

use App\Models\Translation;
use App\Models\LanguageLine;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class TranslationsImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $collection)
    {
        foreach ($collection as $row) {
            if (!$row['key']) {
                continue;
            }
            
            LanguageLine::create([
                'group' => trim($row['group']),
                'key' => $row['key'],
                'text' => [
                    'en' => trim($row['en']),
                    'de' => trim($row['de'] ?? $row['en']),
                    'fr' => trim($row['fr'] ?? $row['en']),
                    'ru' => trim($row['ru'] ?? $row['en']),
                ],
            ]);
        }
    }
}
