<?php

namespace App\Mail;

use App\Models\AuthUser;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class OrderConfirmed extends Mailable
{
    use Queueable, SerializesModels;

    public $orderMaster;

    public $voucher;

    /**
     * Create a new message instance.
     *
     * @param $orderMaster
     * @param $voucher
     */
    public function __construct($orderMaster, $voucher)
    {
        $this->orderMaster = $orderMaster;
        $this->voucher = $voucher;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(trim(ucwords(AuthUser::find($this->orderMaster->MUserID)->AuthUserCompany)) . ' Order: ' . $this->orderMaster->MOrderKey . '-' . $this->orderMaster->MOrderID)
                    ->from([
                        'address' => 'confirmation@jamtransfer.com',
                        'name'    => 'JamTransfer',
                    ])
                    ->replyTo('info@jamtransfer.com')
                    ->view('emails.orderConfirmed')
                    ->attach('./pdf/' . $this->orderMaster->MOrderKey . '-' . $this->orderMaster->MOrderID . '.pdf');
    }
}
