<?php

namespace App\Mail;

use App\Models\AuthUser;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Voucher extends Mailable
{
    use Queueable, SerializesModels;

    public $transfer;

    public $orderId;

    /**
     * Create a new message instance.
     *
     * @param $transfer
     * @param $orderId
     */
    public function __construct($transfer, $orderId)
    {
        $this->transfer = $transfer;
        $this->orderId = $orderId;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $coData = AuthUser::find('53');

        return $this->subject($coData->AuthUserCompany . ' ' . 'Verification request')
                    ->from([
                        'address' => 'verification@jamtransfer.com',
                        'name' => $coData->AuthUserCompany
                    ])
                    ->replyTo($coData->AuthUserMail)
                    ->view('emails.voucher')
                    ->with(compact('coData'))
                    ->attach('./pdf/' . $this->orderId . '.pdf');
    }
}
