<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'v4_Articles';

    /**
     * @param $query
     * @param $page
     *
     * @return mixed
     */
    public function scopeForPage($query, $page)
    {
        return $query->where('Page', $page)
                     ->where('Published', '1')
                     ->where('Language', app()->getLocale())
                     ->orderBy('Position', 'asc')
                     ->select(['Article as text']);
    }
}
