<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderMasterTemp extends Model
{
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'v4_OrdersMasterTemp';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'MOrderID';

    /**
     * The model's attributes.
     *
     * @var array
     */
    protected $attributes = [
        'MPaymentStatus' => 0,
        'MInvoiceAmount' => 0,
        'MAgentCommision' => 0,
        'MCustomerID' => 0,
        'MCardType' => '',
        'MCardFirstName' => '',
        'MCardLastName' => '',
        'MCardEmail' => '',
        'MCardTel' => '',
        'MCardAddress' => '',
        'MCardCity' => '',
        'MCardZip' => '',
        'MCardNumber' => '',
        'MCardCVD' => '',
        'MCardExpDate' => '',
        'MConfirmFile' => '',
        'MCancelFile' => '',
        'MChangeFile' => '',
        'MEmailSentDate' => '',
        'MCustomerIP' => '',
        'MOrderLang' => '',
    ];

    public function details()
    {
        return $this->hasMany(OrderDetailsTemp::class, 'OrderID', 'MOrderID');
    }

    public function setMTransferPriceAttribute($value)
    {
        $this->attributes['MTransferPrice'] = $value ?? 0;
    }

    public function setMExtrasPriceAttribute($value)
    {
        $this->attributes['MExtrasPrice'] = $value ?? 0;
    }
}
