<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Place extends Model
{
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'v4_Places';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'PlaceID';

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo(Country::class, 'PlaceCountry', 'CountryID');
    }

    public function scopeSearch($query, $search)
    {
        return $query->with('country')
                     ->where('PlaceActive', 1)
                     ->where(function ($qry) use ($search) {
                         $qry->where('PlaceName' . Lang(), 'LIKE', "$search%")
                             ->orWhere('PlaceNameSEO', 'LIKE', "$search%");
                     })
                     ->orderBy('PlaceName' . Lang(), 'ASC');
    }

    public function scopeActive($query)
    {
        return $query->where('PlaceActive', 1);
    }
}
