<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Route extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'v4_Routes';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'RouteID';

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function driverRoutes()
    {
        return $this->hasMany(DriverRoute::class, 'RouteID', 'RouteID')->orderBy('OwnerID');
    }
}
