<?php

namespace App\Services;

use App\Models\AuthUser;
use App\Models\OrderMaster;
use App\Models\CompanyInfo;
use App\Models\OrderMasterTemp;

class PrintVoucher
{
    private static $users = ['2', '4', '5', '6', '12'];

    public static function execute($orderId)
    {
        $orderMaster = OrderMaster::find($orderId);

        $userCo = static::getUserCo($orderMaster->MUserID);

        $selectedVehiclePrice = static::formatSelectedVehiclePrice($orderMaster);

        return view('voucher', compact('orderMaster', 'userCo', 'selectedVehiclePrice'))->render();
    }

    /**
     * @param  int  $userId
     *
     * @return string
     */
    private static  function getUserCo(int $userId)
    {
        $authUser = AuthUser::find($userId);

        return in_array(optional($authUser)->AuthLevelID, static::$users) ? $authUser->AuthUserCompany : CompanyInfo::first()->co_name;
    }

    /**
     * @param  OrderMasterTemp  $transfer
     *
     * @return string
     */
    private static function formatSelectedVehiclePrice($transfer)
    {
        return $transfer->details->count() == 2
            ? Eur2($transfer->details->first()->DetailPrice + $transfer->details->last()->DetailPrice, $transfer->MOrderCurrency)
            : Eur2($transfer->details->first()->DetailPrice, $transfer->MOrderCurrency);
    }
}
