<?php

use App\Models\LanguageLine;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\PageController;
use App\Http\Controllers\Api\WebpayController;
use App\Http\Controllers\Api\CouponController;
use App\Http\Controllers\Api\BookingController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\AirportsController;
use App\Http\Controllers\Api\HomePageController;
use App\Http\Controllers\Api\TransfersController;
use App\Http\Controllers\Api\TerminalsController;
use App\Http\Controllers\Api\EmailQuoteController;
use App\Http\Controllers\Api\HelpCenterController;
use App\Http\Controllers\Api\PlacesSearchController;
use App\Http\Controllers\Api\DriverExtrasController;
use App\Http\Controllers\Api\TranslationsController;
use App\Http\Controllers\Api\ConfirmOrderController;
use App\Http\Controllers\Api\TravelAgenciesPartnershipProposalController;

Route::group(['middleware' => ['locale']], function () {
    Route::get('search-place', [PlacesSearchController::class, 'searchPlace']);
    Route::get('taxi-transfers-from-{placeFrom}', [PlacesSearchController::class, 'searchPlace']);
    
    Route::get('available-places', [AirportsController::class, 'getAvailablePlaces']);
    Route::get('available-destinations', [AirportsController::class, 'getAvailableDestinations']);
    Route::get('countries', [AirportsController::class, 'getPlacesGroupedByCountry']);
    
    Route::post('save-booking', [BookingController::class, 'save']);
    
    Route::get('transfers', [TransfersController::class, 'index']);
    Route::get('transfer', [TransfersController::class, 'transfer']);
    Route::get('get-transfer-details-form', [TransfersController::class, 'getTransferDetailsForm']);
    
    Route::get('extras/{driverId}', [DriverExtrasController::class, 'index']);
    Route::post('extras', [DriverExtrasController::class, 'store']);
    
    Route::get('request-quote', [EmailQuoteController::class, 'index']);
    Route::post('request-transfer-quote', [EmailQuoteController::class, 'getTransferQuote']);
    
    Route::post('check-coupon', [CouponController::class, 'index']);
    Route::post('coupon/update-count', [CouponController::class, 'updateCount']);
    
    Route::get('place', [PlacesSearchController::class, 'find']);
    Route::get('destinations', [PlacesSearchController::class, 'destinations']);
    Route::get('description', [PlacesSearchController::class, 'description']);
    
    Route::get('get-form', [WebpayController::class, 'getForm'])->name('get.monri.credentials');
    Route::post('success', [WebpayController::class, 'success']);
    Route::post('update-online-payment', [WebpayController::class, 'updateOnlinePayment']);
    
    Route::get('get-payment-info', [TransfersController::class, 'getPaymentInfo']);
    
    Route::get('confirmOrder/{id?}', [ConfirmOrderController::class, 'index'])->name('confirmOrder');
    Route::post('confirmOrder', [ConfirmOrderController::class, 'index']);
    Route::post('cancelOrder', [ConfirmOrderController::class, 'index']);
    
    Route::get('translations', [TranslationsController::class, 'get'])->name('get.translations');
    Route::get('delete-translations-cache', [TranslationsController::class, 'bustCache']);
    
    Route::get('page/{page}', [PageController::class, 'get']);
    Route::get('home-page', [HomePageController::class, 'get']);
    
    Route::post('contact', [ContactController::class, 'index']);
    
    Route::get('for-travel-agencies-page', [TravelAgenciesPartnershipProposalController::class, 'index']);
    Route::post('for-travel-agencies-page/proposal', [TravelAgenciesPartnershipProposalController::class, 'proposal']);
    
    Route::get('help-center/categories', [HelpCenterController::class, 'getCategories']);
    
    
    Route::get('terminals/top', [TerminalsController::class, 'getTop']);
    Route::get('terminals/bust-cache', [TerminalsController::class, 'bustCache']);
    Route::get('terminals/description', [TerminalsController::class, 'getDescription']);
});
